var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl=system.getObject("web.oplogCtl");
class InvoiceApplyCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(InvoiceApplyCtl));
     this.pushmsgWxop = system.getObject("wxop.pushmsgWxop");
     this.mailClient = system.getObject("util.mailClient");
     this.orderSve = system.getObject("service.orderSve");
   }
   async submitInvoice(pobj,obj,req){
     try {
        obj.createuser_id=req.session.user.id;
        obj.invoiceContent="知识产权服务费";
        obj.invoiceHeadUpType="ent";
        obj.company_id=req.companyid;
        //  var invoiceInfo=await this.service.create(obj);
        var result=await this.service.submitInvoice(obj);
        if(result && result.code==1 && result.data){
          return system.getResult2(result.data);
        }else{
          return system.getResult2(null,null);
        }
        //  return system.getResult2(invoiceInfo);
     } catch (e) {
        return system.getResult2(null,null);
     }
     
   }
   //公众号、邮箱消息推送
   async msgSend(invoiceapply_id,user){
    var self = this;
    this.service.dao.model.findOne({
      where:{id:invoiceapply_id},
      include:[
        { model: this.service.db.models.company, as: "company", attributes: ["name","domainname"]}
      ],
      raw:true
     }).then(invoice=>{
       if(invoice && invoice.id && invoice["company.domainname"]){
         self.orderSve.dao.model.findOne({
           where:{invoiceapply_id:invoice.id},
           raw:true
         }).then(order=>{
           if(order && order.id){
             if(invoice.email){
               var text="【知圈圈】尊敬的用户，您的商标【"+order.name+"】，订单号【"+order.code+"】的发票已经开出，请您登录『"+invoice['company.domainname']+"』平台，在发票管理处提交邮寄信息。";
               self.mailClient.sendMsg(invoice.email, "发票通知", null, text, null, null, []); //发送成功后result的值:250 Data Ok: queued as freedom 
             }
             if(invoice.mobile){
               var text="尊敬的用户，您的商标【"+order.name+"】，订单号【"+order.code+"】的发票已经开出，请您登录『"+invoice['company.domainname']+"』平台，在发票管理处提交邮寄信息。";
               self.pushmsgWxop.pushMsg({
                 company_id:user.company_id,mobile:invoice.mobile,title:text,itemName:"申请发票",progress:"已完成"
               });
             }
           }
         })
         
       }
     }).catch(e=>{
       console.log(e);
     })
   }
   async auditExpress(pobj,obj,req){
     var user = req.session.user;
     var params={
       id:obj.id,
       invoiceStatus:"finished",
       opNotes:obj.opNotes,
       auditStatus:"tg",
       updator:req.session.user.nickName,
       updateuser_id:req.session.user.id,
       auditor:req.session.user.nickName,
       audituser_id:req.session.user.id
     }
     var result=await this.service.update(params);
     this.msgSend(obj.id,user);//消息推送
     return system.getResult2(result,null);
   }
   //查询订单发票
   async findAllOrderInvoice(obj,req){
      var user = req.session.user;
      if(user){
        obj["user"]=user;
        try {
          return this.service.findAllOrderInvoice(obj);
        } catch (e) {
          //日志记录
          logCtl.error({
            optitle: "查询订单发票操作异常error",
            op: "/igirl-web/app/base/controller/impl/invoiceApplyCtl.js/findAllOrderInvoice",
            content: e.stack,
            clientIp: ""
          });
          return { code: -200, msg: "操作失败" };
        }
      }else{
        return {code:-100,msg:"未知用户"};
      }
   }
   //订单发票提交申请
   async orderInvoiceSubmit(pobj,obj,req){
      var user = req.session.user;
      if(user){
        obj["user"]=user;
        try {
          return this.service.orderInvoiceSubmit(obj);
        } catch (e) {
          //日志记录
          logCtl.error({
            optitle: "订单发票提交申请操作异常error",
            op: "/igirl-web/app/base/controller/impl/invoiceApplyCtl.js/orderInvoiceSubmit",
            content: e.stack,
            clientIp: ""
          });
          return { code: -200, msg: "操作失败" };
        }
      }else{
        return {code:-100,msg:"未知用户"};
      }
   }
}
module.exports=InvoiceApplyCtl ;
// var task = new InvoiceApplyCtl();
// task.findAllOrderInvoice({},null).then(d=>{
//   console.log(d);
//   console.log(d.data.length);
// })