var System = require("../../system")
const uuidv4 = require('uuid/v4');
const crypto = require('crypto');
const cryptoJS = require("crypto-js");
const querystring = require('querystring');
const logCtl = System.getObject("web.oplogCtl");
var settings = require("../../../config/settings");
var moment = require('moment');
const md5 = require("MD5");
class TestApi {
  constructor() {
    this.bytmmonitSve = System.getObject("service.bytmmonitSve");
    this.utilscloudSve = System.getObject("service.utilscloudSve");
    this.trademarkSve = System.getObject("service.trademarkSve");
    this.businesscompanySve = System.getObject("service.businesscompanySve");
    this.utilstmTransactionSve = System.getObject("service.utilstmTransactionSve");
    this.utilstmtasktradeSve = System.getObject("service.utilstmtasktradeSve");
    this.zxyTransferMchtId = settings.apiconfig.zxyTransferMchtId();
    this.GsbByTmSearchApi = System.getObject("api.bytmsearch");
    this.utilstmSve = System.getObject("service.utilstmSve");
    this.utilscontent = System.getObject("service.utilscontentfilterSve");
    this.tm_type = { P: "普通商标", J: "集体商标", Z: "证明商标", T: "特殊商标" };
    this.tm_status = { 1: "申请中", 2: "已初审", 3: "已注册", 4: "已无效", 5: "其他" };
    this.imageQueryUrl = settings.apiconfig.imageQueryUrl();
    this.tm_gjfl = {
      1: "01类 化学原料", 2: "02类 颜料油漆", 3: "03类 日化用品", 4: "04类 燃料油脂", 5: "05类 医药", 6: "06类 金属材料", 7: "07类 机械设备", 8: "08类 手工器械", 9: "09类 科学仪器",
      10: "10类 医疗器械", 11: "11类 灯具空调", 12: "12类 运输工具", 13: "13类 军火烟火", 14: "14类 珠宝钟表", 15: "15类 乐器", 16: "16类 办公用品", 17: "17类 橡胶制品", 18: "18类 皮革皮具", 19: "19类 建筑材料", 20: "20类 家具", 21: "21类 厨房洁具", 22: "22类 绳网袋蓬", 23: "23类 纱线丝", 24: "24类 布料床单",
      25: "25类 服装鞋帽", 26: "26类 钮扣拉链", 27: "27类 地毯席垫", 28: "28类 健身器材", 29: "29类 食品", 30: "30类 方便食品", 31: "31类 农林生鲜", 32: "32类 啤酒饮料", 33: "33类 酒", 34: "34类 烟草烟具", 35: "35类 广告销售", 36: "36类 金融物管", 37: "37类 建筑修理", 38: "38类 通讯服务",
      39: "39类 运输贮藏", 40: "40类 材料加工", 41: "41类 教育娱乐", 42: "42类 科技服务", 43: "43类 餐饮住宿", 44: "44类 医疗园艺", 45: "45类 社会服务"
    };
  }
  convertDate(time) {
    if (time == null) {
      return "";
    }
    var date = new Date(Number(time * 1000));
    var y = 1900 + date.getYear();
    var m = "0" + (date.getMonth() + 1);
    var d = "0" + date.getDate();
    return y + "-" + m.substring(m.length - 2, m.length) + "-" + d.substring(d.length - 2, d.length);
  }
  async test(obj) {
    // try {
    //   var result = await this.businesscompanySve.recycleBusiness();
    //   // var result = await this.businesscompanySve.freeClaimOperation({ id: 41, company_id: 4 }, "xz", [1095, 1113]);
    //   // var result = await this.businesscompanySve.protectBus({ id: 41, company_id: 4 }, "xz", ["RL20190429114493kNw4", "RL2019042911449mftfK"]);
    //   console.log(result, "result..................");
    //   return result;
    // } catch (e) {
    //   console.log(e.stack, "e.......................");
    // }
  }
  async callSign() {
    var tmpSignObj = {
      "accNo": "6214850112377038", "accType": "00", "amt": 100,
      "appId": "1103817785", "busiId": "1103817785420820481",
      "currency": "CNY", "idName": "宋毅", "idNo": "341221198504218256",
      "idType": "00", "mobile": "15010929366", "note": "知产平台转账操作",
      "notityUrl": "http://igirl.gongsibao.com/api/xbg/transferNotify",
      "outTradeNo": "fxfx_XxHqg5hLlP", "platformSeqNo": "1120991431960649729",
      "respCode": "00", "respDesc": "成功", "seqNo": "1001",
      "sign": "6E1F113FDBA02F37DB53C5273EF847AF", "signType": "MD5", "tradeStatus": "00",
      "tradeTime": "20190424180307", "tradeType": "00"
    };

    var signArr = [];
    signArr.push("accNo=" + tmpSignObj.accNo);
    signArr.push("accType=" + tmpSignObj.accType);
    signArr.push("amt=" + tmpSignObj.amt);
    signArr.push("appId=" + tmpSignObj.appId);
    signArr.push("busiId=" + tmpSignObj.busiId);
    signArr.push("currency=" + tmpSignObj.currency);
    signArr.push("idName=" + tmpSignObj.idName);
    signArr.push("idNo=" + tmpSignObj.idNo);
    signArr.push("idType=" + tmpSignObj.idType);
    signArr.push("mobile=" + tmpSignObj.mobile);
    signArr.push("note=" + tmpSignObj.note);
    signArr.push("notityUrl=" + tmpSignObj.notityUrl);
    signArr.push("outTradeNo=" + tmpSignObj.outTradeNo);
    signArr.push("platformSeqNo=" + tmpSignObj.platformSeqNo);
    signArr.push("respCode=" + tmpSignObj.respCode);
    signArr.push("respDesc=" + tmpSignObj.respDesc);
    signArr.push("seqNo=" + tmpSignObj.seqNo);
    signArr.push("signType=" + tmpSignObj.signType);
    signArr.push("tradeStatus=" + tmpSignObj.tradeStatus);
    signArr.push("tradeTime=" + tmpSignObj.tradeTime);
    signArr.push("tradeType=" + tmpSignObj.tradeType);
    signArr.push("key=ca47edd3ae8bac3f7a68d8126d891f52");
    // accNo=6214850112377038&accType=00&amt=100&appId=1103817785&busiId=1103817785420820481&
    // currency=CNY&idName=宋毅&idNo=341221198504218256&idType=00&mobile=15010929366&note=测试-知圈圈&
    // notityUrl=http://bpohhr.gongsibao.com/api/econtractApi/transferNotify&outTradeNo=PRO201903251623VGjsy01&platformSeqNo=1116256506449272833&respCode=00&respDesc=成功&seqNo=1001&signType=MD5&tradeStatus=00&tradeTime=20190411162729&tradeType=00&key=ca47edd3ae8bac3f7a68d8126d891f52
    var signStr = signArr.join("&");
    console.log(signStr, "，signStr.......................");

    var tmpSign = md5(signStr).toUpperCase();

    console.log(tmpSign, "，tmpSign.......................");
    return tmpSign;
  }
  async test_busiAccount() {
    try {
      var tmpOrderNum = await this.bytmmonitSve.getUidInfo(10, 60);
      var tmpParams = {
        "orderNo": tmpOrderNum
      };
      var result = await this.utilscloudSve.busiAccount(tmpParams);
      console.log(result, "result..................");
      return result;
    } catch (e) {
      console.log(e.stack, "e.......................");
      return e.stack;
    }
  }
  async test_user_sign() {
    try {
      var tmpParams = {
        // "note": "测试",
        // "idType": "00",
        // "idName": "宋毅",
        // "seqNo": "1001",
        // "accNo": "6225881007370116",
        // "mobile": "18600440811",
        // "idNo": "222403198301071778",
        // "signedName": "北京创知科技有限公司"

        "note": "测试",
        "idType": "00",
        "idName": "张建铜",
        "seqNo": "1001",
        "accNo": "6226220116724286",
        "mobile": "13653419486",
        "idNo": "140105199210022216",
        "signedName": "北京创知科技有限公司"
      };
      var result = await this.utilscloudSve.userSign(tmpParams);
      console.log(result, "result.................");
    } catch (e) {
      console.log(e.stack, "e......................");
    }
  }
  async test_user_transfer() {
    try {
      var tmpOrderNum = await this.bytmmonitSve.getUidInfo(10, 60);
      // var obj = {
      //   orderNo: "fxfx_" + tmpOrderNum,// obj.orderNo,//"sysyO201903251623VGjnw06",
      //   bizs: [{
      //     "note": "测试",
      //     "idType": "00",
      //     "idName": "宋毅",
      //     "seqNo": "1001",
      //     "accNo": "6214850112377038",
      //     "mobile": "15010929366",
      //     "amt": 100,
      //     "accType": "00",
      //     "idNo": "341221198504218256",
      //     "signedName": "北京创知科技有限公司"
      //   }]
      // }
      var obj = {
        orderNo: "fxfx_" + tmpOrderNum,// obj.orderNo,//"sysyO201903251623VGjnw06",
        bizs: [{
          "note": "测试",
          "idType": "00",
          "idName": "宋毅",
          "seqNo": "1001",
          "accNo": "6225881007370116",
          "mobile": "18600440811",
          "amt": 100,
          "accType": "00",
          "idNo": "222403198301071778",
          "signedName": "北京创知科技有限公司"
        }]
      }
      console.log(obj, "params...............");
      var result = await this.utilscloudSve.transfer(obj, 1);
      console.log(result, "result................");
    } catch (e) {
      console.log(e.stack, "e......................");
    }
  }
  async test_wx_notify() {
    // UPDATE `biz_order` SET  totalServiceCharge=0,totalPublicExpense=0,totalDiscounts=0,totalTaxes=0,totalSum=1,totalProfitSum=0,sveItemRateConfig=0  WHERE `code`='TMO201904241644TLHKA'
    try {
      var obj = {
        order_num: "TMO201905291929k94Cx",
        user_id: 41,
        out_trade_no: "123_0177777777777",
        amount: Number(2.00)
      }
      var result = await this.utilscloudSve.wxPayNotify(obj);
      console.log(result, "result..................");
      return result;
    } catch (e) {
      console.log(e.stack, "e.......................");
      return e.stack;
    }
  }

  async test_transaction(data3) {
    var result = { rows: [], total: "" }
    var data = {
      keyword: "",
      tm_nclcode: ["3", "2", "16"],
      price_min: 12000,
      price_max: 3333333333333,
      tm_structure: "纯文字",
      order_field: "year",
      sort: "desc",
      pagesize: 20,
      currentpage: 1
    };
    var data1 = {
      keyword: "",
      tm_nclcode: [],
      price_min: "",
      price_max: "",
      tm_structure: "",
      tm_word: "",
      order_field: "",
      sort: "",
      pagesize: 20,
      currentpage: 1
    };
    var sources = []
    var tms = await this.utilstmTransactionSve.tmTransactionSearch(data3);//获取查询结果
    console.log(tms);
    if (tms.status == 0) {
      result.total = tms.total;
      tms.data.forEach(function (tm) {
        var source = {
          tm_name: tm.tm_name,//商标名称
          platform_quoted_price: tm.platform_quoted_price,//平台售价
          ncl_one_codes: tm.ncl_one_codes,//尼斯大类
          tm_regist_num: tm.tm_regist_num,//注册号
          pic_url: tm.pic_url//图片url
        }
        sources.push(source)
      });
      result.rows = sources;
    }
    console.log("=====================+++++++++++++++++++++++++");
    console.log(result);

    var updatedata = {
      sbzch: "21132600",
      platform_quoted_price: "000.00",
      tm_introduction: "111111111111111111111111111111111111111采集汤出品，必属精品！",
      is_transaction: "1"
    }
    var tt = await this.utilstmTransactionSve.tmTransactionUpdatesve(updatedata);
    console.log("uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu");
    console.log(tt);

    return System.getResult2(result, null);
  }
  async tmTransactionDetail(obj) {//商标交易详情接口
    console.log(obj);
    var result = { detail: {} };
    var sbzch = obj.sbzch;
    var gjfl = obj.gjfl;
    var data = {
      sbzch: sbzch,
      gjfl: gjfl,
    };
    var that = this;
    var detailtms = await this.GsbByTmSearchApi.tradeMarkDetailapi(data);
    var ts = await this.utilstmTransactionSve.tmTransactionDetailsve(data);//获取查询结果
    console.log("================================");
    console.log(ts);
    console.log("================================");
    var data2 = {
      reg_num: sbzch,
      nclone_code: gjfl
    }
    var qunzutms = await this.utilstmSve.getGroupNclInfo(data2);
    var spfwxmlist = [];
    var codelist = [];
    if (qunzutms.status == 0) {
      qunzutms.data.exist.forEach(function (c) {
        if (spfwxmlist.findIndex(f => f == c.small_name) < 0) {
          spfwxmlist.push(c.small_name)
        }
        if (codelist.findIndex(f => f == c.code) < 0) {
          codelist.push(c.code)
        }
      });
    }
    var spfwxm = spfwxmlist.join(",");
    var codes = codelist.join(",");
    var sbmc = "";
    var gjfl = "";
    var gjflname = "";
    var sbzch = "";
    var sbzt = "";
    var sqrq = "";
    var csrq = "";
    var zcrq = "";
    var zcr = "";
    var jzrq = "";
    var yzcr = "";
    var zcdz = "";
    var dljg = "";
    var logo = "";
    var platform_quoted_price = "";
    var tm_introduction = "";
    if (detailtms.status == 0 && detailtms.data.length > 0) {
      var tm = detailtms.data[0];
      sbmc = tm.tm_name;//商标名称
      gjfl = tm.ncl_one_codes;//国际分类
      gjflname = that.tm_gjfl[tm.ncl_one_codes];//国际分类名称
      sbzch = tm.tm_regist_num;//商标注册号
      sbzt = that.tm_status[tm.status];//商标状态
      sqrq = that.convertDate(tm.apply_day);//申请日期
      csrq = that.convertDate(tm.first_notice_day);//初审日期
      zcrq = that.convertDate(tm.original_regist_notice_day);//注册日期
      zcr = tm.applicant_cn;//申请人
      jzrq = that.convertDate(tm.tm_end_day);//截止日期
      yzcr = tm.original_applicant_cn;//原申请人
      zcdz = tm.applicant_cn_addr;//申请地址
      dljg = tm.tm_agency;//代理机构
      logo = tm.pic_url;//商标图样
    }
    if (ts.status == 0 && ts.data.length > 0) {
      var tm = ts.data[0];
      platform_quoted_price = tm.platform_quoted_price;//平台售价
      tm_introduction = tm.tm_introduction;//商标简介
    }
    result.detail = {
      sbmc: sbmc,//商标名称
      gjfl: gjfl,//国际分类
      gjflname: gjflname,//国际分类名称
      sbzch: sbzch,//商标注册号
      sbzt: sbzt,//商标状态
      sqrq: sqrq,//申请日期
      csrq: csrq,//初审日期
      zcrq: zcrq,//注册日期
      zcr: zcr,//申请人
      jzrq: jzrq,//截止日期
      yzcr: yzcr,//原申请人
      zcdz: zcdz,//申请地址
      dljg: dljg,//代理机构
      logo: logo,//商标图样
      spfwxm: spfwxm,//商品/服务项
      codes: codes,//群组
      platform_quoted_price: platform_quoted_price,//平台售价
      tm_introduction: tm_introduction//商标简介
    }
    console.log(result);
    return System.getResult2(result, null);
  }
  async test_tmAuditData() {//商标交易录入es
    try {
      var kk = await this.utilstmtasktradeSve.opAuditData();
      console.log(kk, "kk...................");
      return kk;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "test_tmAuditData错误",
        op: "/igirl-web/app/base/api/impl/testApi.js",
        content: "error：" + JSON.stringify(e.stack),
        clientIp: ""
      });
      console.log(e.stack, "ttttttttt...............");
    }
  }
  async moni() {//商标监控
    await this.bytmmonitSve.getMonitAll();
  }
  async test_disposePublicExpense() {//商标上交官费
    var result = await this.trademarkSve.disposePublicExpense();
  }

}
module.exports = TestApi;
