var WEBBase = require("../../web.base");
var system = require("../../../system");
class TmQueryAPI extends WEBBase {
    constructor() {
        super();
        // this.tmqueryApi = system.getObject("api.trademark.tmqueryApi");
        this.tmquerySve = system.getObject("service.trademark.tmquerySve");
        // this.toolApi = system.getObject("api.tool.toolApi");
        this.toolSve = system.getObject("service.trademark.toolSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj.actionProcess, pobj.actionType, pobj.actionBody, req, pobj);
        return result;
    }
    async opActionProcess(action_process, action_type, action_body, req, pobj) {
        var opResult = null;
        switch (action_type) {
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "tmTest":
                opResult = await this.tmquerySve.test(pobj);
                break;
            case "findTrademarkNameAccurate"://商标精确检索（相同商标检索）
                opResult = await this.tmquerySve.findTrademarkNameAccurate(action_body, req);
                break;
            case "findTrademarkName"://近似商标检索
                opResult = await this.tmquerySve.findTrademarkName(action_body, req);
                break;
            case "findTrademarkzchAccurate"://商标申请号检索
                opResult = await this.tmquerySve.findTrademarkzchAccurate(action_body, req);
                break;
            case "findTrademarkzcr"://申请人查询
                opResult = await this.tmquerySve.findTrademarkzcr(action_body, req);
                break;
            case "getCropperPic"://获取检索图片url 
                opResult = await this.toolSve.getCropperPic(action_body, req);
                break;
            case "imagequery"://图形检索
                opResult = await this.tmquerySve.imagequery(action_body, req);
                break;
            case "findImageSearch"://图形检索查询
                opResult = await this.tmquerySve.findImageSearch(action_body, req);
                break;
            case "tradeMarkDetail"://商标详情查询
                opResult = await this.tmquerySve.tradeMarkDetail(action_body, req);
                break;
            case "sbzuixinsearch"://最新商标查询
                opResult = await this.tmquerySve.sbzuixinsearch(action_body, req);
                break;
            case "noticequeryTMZCSQ"://近12期初审公告查询接口
                opResult = await this.tmquerySve.noticequeryTMZCSQ(action_body, req);
                break;
            case "noticequery"://公告列表检索接口
                opResult = await this.tmquerySve.noticequery(action_body, req);
                break;
            case "noticezcggsearch"://注册公告详情查询
                opResult = await this.tmquerySve.noticezcggsearch(action_body, req);
                break;
            case "noticesearch"://初审公告详情查询
                opResult = await this.tmquerySve.noticesearch(action_body, req);
                break;
            case "getCompanyInfoNoUser"://企业查询
                opResult = await this.tmquerySve.getCompanyInfoNoUser(action_body, req);
                break;
            case "getNclDetail"://尼斯详情
                opResult = await this.tmquerySve.getNclDetail(action_body, req);
                break;
            case "gettwoNcl"://获取尼斯群组
                opResult = await this.tmquerySve.gettwoNcl(action_body, req);
                break;
            case "nclFuwuSearch"://尼斯分类检索
                opResult = await this.tmquerySve.nclFuwuSearch(action_body, req);
                break;
            case "bycznfx"://商标智能分析  -----
                opResult = await this.toolSve.bycznfx(action_body, req);
                break;
            case "tmConfirm"://商标方案确认
                // opResult = await this.toolApi.bycznfx(action_body);
                opResult = system.getResultSuccess(null, "商标方案确认成功");
                break;
            case "icheming"://商标智能分析  -----
                opResult = await this.toolSve.icheming(action_body, req);
                break;
            case "tmreport"://商标报告
                var rtn = await this.tmquerySve.tmreport(action_body, pobj, req);
                if (rtn.code > 0) {
                    opResult = system.getResultSuccess();
                } else {
                    opResult = system.getResult(null, rtn.msg);
                }
                break;
            case "getNclByCode":
                opResult = await this.toolSve.getNclByCode(pobj,req);
                break;
            case "getAllNcl":
                opResult = await this.toolSve.getAllNcl(pobj,req);
                break;
            case "tmstatistics": //商标统计接口总量、有效、申请
                opResult = await this.tmquerySve.tmstatistics(action_body,req);
                break;
            case "tmcompanystatistics": //商标统计接口公司总量
                opResult = await this.tmquerySve.tmcompanystatistics(action_body,req);
                break;
            case "tmaddrstatisticsrank"://商标地区分布统计排名
                opResult = await this.tmquerySve.tmaddrstatisticsrank(action_body,req);
                break;
            case "tmcompanystatisticsrank": //商标企业分布统计排名
                opResult = await this.tmquerySve.tmcompanystatisticsrank(action_body,req);
                break;
            case "tmnclstatisticsrank": //商标类别申请排名
                opResult = await this.tmquerySve.tmnclstatisticsrank(action_body,req);
                break;
            case "tmtrend": //商标申请及注册趋势
                opResult = await this.tmquerySve.tmtrend(action_body,req);
                break;
            case "tmnclrankdetail": //商标类别申请排名详情
                opResult = await this.tmquerySve.tmnclrankdetail(action_body, req);
                break;
            case "tmcompanyrank": //商标企业分布统计详情
                opResult = await this.tmquerySve.tmcompanyrank(action_body, req);
                break;
            case "tmaddressrankdetail": //商标地区分布统计排名详情
                opResult = await this.tmquerySve.tmaddressrankdetail(action_body, req);
                break;
            case "findTrademarkNameAccuratejuhe": //通过商标名来进行精准查询,商标注册地域/大类分布
                opResult = await this.tmquerySve.findTrademarkNameAccuratejuhe(action_body,req);
                break;
            case "findTrademarkNamejuhe": //根据商标名称模糊查询,商标注册地域/大类分布
                opResult = await this.tmquerySve.findTrademarkNamejuhe(action_body,req);
                break;
            case "checkName": //根据商标名称模糊查询,商标注册地域/大类分布
                opResult = await this.tmquerySve.checkName(action_body,req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = TmQueryAPI;