const system = require("../system");
const settings = require("../../config/settings");
const DocBase = require("./doc.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
class APIBase extends DocBase {
    constructor() {
        super();
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.logCtl = system.getObject("service.common.oplogSve");
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    /**
 * 白名单验证
 * @param {*} gname 组名
 * @param {*} methodname 方法名
 */
    async isCheckWhiteList(gname, methodname) {
        var fullname = gname + "." + methodname;
        var lst = [
            "test.testApi"
        ];
        var x = lst.indexOf(fullname);
        return x >= 0;
    }
    async checkAcck(gname, methodname, pobj, query, req) {
        var appInfo = null;
        var result = system.getResultSuccess();
        var ispass = await this.isCheckWhiteList(gname, methodname);
        var appkey = req.headers["accesskey"];
        if (ispass) {
            return result;
        }//在百名单里面
        if (appkey) {
            appInfo = await this.cacheManager["ApiAccessKeyCheckCache"].cache(appkey, { status: true }, 3000);
            if (!appInfo || !appInfo.app) {
                result.status = system.tokenFail;
                result.msg = "请求头accesskey失效，请重新获取";
            }
        }//验证accesskey
        else {
            result.status = -1;
            result.msg = "请求头没有相关访问参数，请验证后在进行请求";
        }
        return result;
    }
    async doexec(gname, methodname, pobj, query, req) {
        var requestid = this.getUUID();
        try {
            //验证accesskey或验签
            // var isPassResult = await this.checkAcck(gname, methodname, pobj, query, req);
            // if (isPassResult.status != 0) {
            //     isPassResult.requestid = "";
            //     return isPassResult;
            // }
            var rtn = await this[methodname](pobj, query, req);
            rtn.requestid = requestid;

            this.logCtl.createDb({
                appid: req.headers["app_id"] || "",
                appkey: req.headers["accesskey"] || "",
                requestId: requestid,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(rtn),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            return rtn;
        } catch (e) {
            console.log(e.stack, "api调用出现异常，请联系管理员..........")
            this.logCtl.error({
                appid: req.headers["app_id"] || "",
                appkey: req.headers["accesskey"] || "",
                requestId: requestid,
                op: pobj.classname + "/" + methodname,
                content: e.stack,
                clientIp: pobj.clientIp,
                agent: req.uagent,
                optitle: "api调用出现异常，请联系管理员",
            });
            var rtnerror = system.getResultFail(-200, "出现异常，请联系管理员");
            rtnerror.requestid = requestid;
            return rtnerror;
        }
    }
}
module.exports = APIBase;

