const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("tmstuff", {   
        stuffTypeName:DataTypes.STRING(50),  //                                                                                                                                                                                             
        stuffType    : {
              type: DataTypes.ENUM,
              values: Object.keys(uiconfig.config.pdict.stuff_type),
              set: function (val) {
                this.setDataValue("stuffType", val);
                this.setDataValue("stuffTypeName", uiconfig.config.pdict.stuff_type[val]);
              },
              defaultValue: "0",
        },  //附件类型:csty: 彩色图样, wts: 委托书, gzwts: 盖章委托书, ty: 图样 , sywj: 声音文件 , smwj: 说明文件                                                                
            // 注：彩色商标图样：商标类型形式为7则有此值                                                                                                                                
        stuffUrl     :DataTypes.STRING(500), // 附件地址                                                                                                                                                                                 
        notes        :DataTypes.STRING,      // 备注                                                                                                                                                                                       
        name         :DataTypes.STRING(1000),//  附件名称                                                                                                                                                                                 
        code         :DataTypes.STRING(100), // 附件code编码                                                                                                                                                                              
        sourceOrderNo:DataTypes.STRING(64),  //来源单号                                                                                                                                                                                 
        app_id       :DataTypes.INTEGER,     //                                                                                                                                                                                             
        createuser_id:DataTypes.INTEGER,     //    
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'b_tmstuff',
      validate: {

      },
      indexes: [
     
      ]
    });
}
