const system = require("../../../system");
const Dao = require("../../dao.base");
class AppUserDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppUserDao));
  }
  async getItemByUUserId(uUserName, appId) {
    return this.model.findOne({
      where: {
        uUserName: uUserName,
        app_id: appId
      },
      attributes: ["id",
        "app_id",
        "channelUserId",
        "channelUserName",
        "uUserName",
        "uAppId",
        "userMoblie",
        "nickname",
        "orgName",
        "orgPath",
        "isEnabled",
        "loginNum",
        "lastLoginTime"],
      raw: true
    });
  }
}
module.exports = AppUserDao;
