var System = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const ApiBase = require("../../api.base");

class WPatentAggregationsApi extends ApiBase {
  constructor() {
    super();
    this.patentUrl = settings.reqEsAddrIc() + "bigdata_world_patent_bib_op/_search";
  };

  async ApplicantAggs(obj) {//申请人排名聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppCountryAggs(obj) {//申请人归属国聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "applicant_country",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async filingyearAggs(obj) {//申请年份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "app_year",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async pubyearAggs(obj) {//公开年份聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "pub_year",
            "size": 20,
            "order": {
              "_term": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CountryAggs(obj) {//各国专利聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "db_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclcAggs(obj) {//Ipc大类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "large class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclcMutiAggs(obj) {//申请人Ipc大类聚合//Ipc小类聚合申请人Ipc大类聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的大类，再加上前十申请人条件和前十大类条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CountryIpclcMutiAggs(obj) {//各国Ipc大类聚合//Ipc小类聚合各国Ipc大类聚合,业务逻辑，，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "db_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcscAggs(obj) {//Ipc小类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "sub_class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcscMutiAggs(obj) {//Ipc小类聚合申请人Ipc小类聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的小类，再加上前十申请人条件和前十小类条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "sub_class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CountryIpcscMutiAggs(obj) {//各国Ipc小类聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "db_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "sub_class",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclgAggs(obj) {//Ipc大组聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "large_group",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpclgMutiAggs(obj) {//申请人Ipc大组聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的大组，再加上前十申请人条件和前十大组条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large_group",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CountryIpclgMutiAggs(obj) {//各国Ipc大组聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "db_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "large_group",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcAggs(obj) {//Ipc聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "main_ipc",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppIpcMutiAggs(obj) {//申请人Ipc直属聚合,业务逻辑，先查询申请排名前十的申请人，再加上前十申请人的条件查询排名前十的IPC，再加上前十申请人条件和前十IPC条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async CountryIpcMutiAggs(obj) {//各国Ipc直属聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "db_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async AppfilingyearAggs(obj) {//申请人申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_appl": {
          "terms": {
            "field": "applicant_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_filingyear": {
              "terms": {
                "field": "app_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }

  };

  async InventorAggs(obj) {//发明人排名聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvIpcMutiAggs(obj) {//发明人Ipc直属聚合,业务逻辑，先查询申请排名前十的发明人，再加上前十发明人的条件查询排名前十的IPC，再加上前十发明人条件和前十IPC条件，多重聚合,这个是最后一次聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_ipc": {
              "terms": {
                "field": "main_ipc",
                "size": 10,
                "order": {
                  "_term": "desc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvfilingyearAggs(obj) {//发明人申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_filingyear": {
              "terms": {
                "field": "app_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async InvPubyearAggs(obj) {//发明人公开趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_inv": {
          "terms": {
            "field": "inventor_name.raw",
            "size": 10,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_pubyear": {
              "terms": {
                "field": "pub_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async CountryfilingyearAggs(obj) {//国家申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_country": {
          "terms": {
            "field": "db_name",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_filingyear": {
              "terms": {
                "field": "app_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcFilingyearAggs(obj) {//IPC申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "main_ipc",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "app_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcLgFilingyearAggs(obj) {//IPC大组申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "large_group",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcLcFilingyearAggs(obj) {//IPC大类申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "large class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };

  async IpcScFilingyearAggs(obj) {//IPC小类申请趋势聚合
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "bool": {
                  "must_not": {
                      "wildcard": {
                          "main_ipc": "*-*"
                      }
                  }
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "group_by_ipc": {
          "terms": {
            "field": "sub_class",
            "size": 20,
            "order": {
              "_count": "desc"
            }
          },
          "aggregations": {
            "group_by_year": {
              "terms": {
                "field": "filing_year",
                "size": 10,
                "order": {
                  "_term": "asc"
                }
              }
            }
          }
        }
      }
    };

    for (var x in obj) {
      params.query.bool.must.push(obj[x]);
    }

    var rc = System.getObject("util.execClient");
    var rtn = null;
    var requrl = this.patentUrl;
    try {
      rtn = await rc.execPost(params, requrl);
      var j = JSON.parse(rtn.stdout);
      return rtn = {
        status: 0,
        msg: "操作成功",
        data: j.hits,
        buckets: j.aggregations
      };
    } catch (e) {
      return rtn = {
        status: -1,
        msg: "操作失败",
        data: null,
        buckets: null
      };
    }
  };




}
module.exports = WPatentAggregationsApi;