const system=require("../../../system");
const settings=require("../../../../config/settings");
const uiconfig=system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("uploadrpt", {
    companycode:{
      type:DataTypes.STRING,
      allowNull: false,
     },
      companyname: {
        type:DataTypes.STRING,
        allowNull: false,
      },
      rpttypecode: {
        type:DataTypes.STRING,
        allowNull: false,
      },
      timetypecode: {
        type:DataTypes.ENUM,
        allowNull: false,
        values: Object.keys(uiconfig.config.pdict.time_type),
        set:function(val){
          this.setDataValue("timetypename",uiconfig.config.pdict.time_type[val]);
          this.setDataValue("timetypecode",val);
        }
     },
     timetypename:{
        type:DataTypes.STRING,
        allowNull: false,
     },
    urlpath:{
        type:DataTypes.STRING,
        allowNull: false,
    },
    rptdate:{
        type:DataTypes.STRING,
        allowNull: false,
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'upload_rpt',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
