const system=require("../../../system");
const settings=require("../../../../config/settings");
const uiconfig=system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("uploadbatch", {
    userid:{
      type:DataTypes.STRING,
      allowNull: true,
    },
    companycode:{
      type:DataTypes.STRING,
      allowNull: false,
   },
    companyname:{
        type:DataTypes.STRING,
        allowNull: false,
        description:"公司"
    },
    name:{
        type:DataTypes.STRING,
        allowNull: false,
    },
    batchstatuscode:{//状态
        type:DataTypes.ENUM,
        allowNull: false,
        values: Object.keys(uiconfig.config.pdict.batch_status),
        set:function(val){
          this.setDataValue("batchstatusname",uiconfig.config.pdict.batch_status[val]);
          this.setDataValue("batchstatuscode",val);
        }
    },
    batchstatusname:{//状态
        type:DataTypes.STRING,
        allowNull: false,
    },
    taxtypecode:{//公司类型--S/G
        type:DataTypes.ENUM,
        allowNull: false,
        values: Object.keys(uiconfig.config.pdict.tax_type),
        set:function(val){
          this.setDataValue("taxtypename",uiconfig.config.pdict.tax_type[val]);
          this.setDataValue("taxtypecode",val);
        }
    },
    taxtypename:{//公司类型--S/G
        type:DataTypes.STRING,
        allowNull: false,
    },

    timetypecode: {
        type:DataTypes.ENUM,
        allowNull: false,
        values: Object.keys(uiconfig.config.pdict.time_type),
        set:function(val){
          this.setDataValue("timetypename",uiconfig.config.pdict.time_type[val]);
          this.setDataValue("timetypecode",val);
        }
     },
     timetypename:{
        type:DataTypes.STRING,
        allowNull: false,
     },
     batchdate:{//检测的月度
        type:DataTypes.STRING,
        allowNull: false,
     },
    accountstandardcode:{//会计准则
        type:DataTypes.ENUM,
        allowNull: false,
        values: Object.keys(uiconfig.config.pdict.account_standard),
        set:function(val){
          this.setDataValue("accountstandardname",uiconfig.config.pdict.account_standard[val]);
          this.setDataValue("accountstandardcode",val);
        }
    },
    accountstandardname:{
        type:DataTypes.STRING,
        allowNull: false,
    },
    wordrpturl:{
      type:DataTypes.STRING,
      allowNull: true,
    }
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     //freezeTableName: true,
     // define the table's name
     tableName: 'upload_batch',
     validate: {

     },
     indexes:[
       // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
         //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
         //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
         //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
     ]
  });
}
