var APIBase =require("../../api.base");
var system=require("../../../system");
class RptAPI extends APIBase{
   constructor(){
       super();
       this.rptService=system.getObject("service.rpt.rpttypeSve");
    }
   /*{
	"companyName": "客户名称", // 公司名称 | type string
	"companyTaxNum" "123456", // 公司税号 | type string
	"valueAddedTax": 1, // 纳税人性质, 1:小规模纳税人, 2:一般纳税人 | type number
	"accountingType": 1, // 会计制度, 1:企业会计准则, 2: 小企业会计准则 | type number
	"dateType": 1, // 时间类型, 1: 月度, 2: 季度, 3: 年度 | type number
	"date": "2019", // 时间,
	"balanceReportsUrl": [ // 资产负债表
		{
			"date": "201910",
			"reportName": "",
			"url": "url"
		},
		{
			"date": "201911",
			"reportName": "",
			"url": "url"
		}
	],
	"profitsReportsUrl": [ // 利润表
		{
			"date": "201910",
			"reportName": "",
			"url": "url"
		},
		{
			"date": "201911",
			"reportName": "",
			"url": "url"
		}
	],
	"valueAddedTaxReportUrl": [ // 增值税申报表
		{
			"date": "201910",
			"reportName": "",
			"url": "url"
		},
		{
			"date": "201911",
			"reportName": "",
			"url": "url"
		},
	],
	"incomeTaxReportUrl": [ // 所得税申报表
		{
			"date": "201910",
			"reportName": "A102010",
			"url": "url"
		},
		{
			"date": "201911",
			"reportName": "A102010",
			"url": "url"
		}
	]
}*/
	async deleteUrlsCache(pobj,query){
		var x=await this.rptService.deleteUrlsCache();
		return system.getResult({});
	}
   async saveRpt(pobj,query){
      var x=await this.rptService.saveRpt(pobj);
      return system.getResult(x);
   }
   async saveRptHistory(pobj,query){
		  pobj.forEach(async (hs)=>{
			   await this.rptService.saveRptHistory(hs);
		  });
        return system.getResult({});
   }
   async queryStatus(pobj,query){
	console.log(JSON.stringify(pobj));
    var x=await this.rptService.queryStatus(pobj);
    return system.getResult(x);
	}
	//{userid:xxx}
	async queryStatus2(pobj,query){
		var x=await this.rptService.queryStatus2(pobj);
		return system.getResult(x);
	}
	//{batchid:xxx,rptUrl:xxxx}
	async updateTaskRptUrl(pobj,query){
		if(pobj){
			var x=await this.rptService.updateTaskRptUrl(pobj);
			return system.getResult(x);
		}else{
			return system.getResult(null);
		}
	}
	async resultJson(pobj,query){
		if(pobj){
			var x=await this.rptService.resultJson(pobj.batchid);
			return system.getResult(x);
		}else{
			return system.getResult(null);
		}
	}
	async buildWordReport(pobj,query){
		if(pobj){
			var x=await this.rptService.buildWordReport(pobj.batchid);
			return system.getResult(x);
		}else{
			return system.getResult(null);
		}
	}
   async queryReport(pobj,query){
	   console.log(JSON.stringify(pobj));
		if(pobj){
			var x=await this.rptService.queryReport(pobj.batchid);
			return system.getResult(x);
		}else{
			return system.getResult(null);
		}
	}
	async queryPosMap(){
		var x=await this.rptService.queryPosMap();
		return system.getResult(x);
	}
   exam(){
    return "xxx";
   }
   classDesc(){
      return {
         groupName:"auth",
         groupDesc:"认证相关的包",
         name:"AccessAuthAPI",
         desc:"关于认证的类",
         exam:"",
     };
   }
   methodDescs(){
      return [
         {
             methodDesc:"生成访问token",
             methodName:"getAccessKey",
             paramdescs:[
                 {
                     paramDesc:"访问appkey",
                     paramName:"appkey",
                     paramType:"string",
                     defaultValue:"x",
                 },
                 {
                     paramDesc:"访问secret",
                     paramName:"secret",
                     paramType:"string",
                     defaultValue:null,
                 }
             ],
             rtnTypeDesc:"xxxx",
             rtnType:"xxx"
         }
     ];
   }
}
module.exports=RptAPI;
// (async ()=>{
// 	var x=new RptAPI();
// 	var m=await x.resultJson({batchid:226});
// 	var xx=JSON.stringify(m);
// 	console.log(xx);
//   })()
  