const ServiceBase = require("../../sve.base");
const system = require("../../../system");
const moment = require('moment')
/**
 * 交付商 提交的信息
 */
class IInvoiceService extends ServiceBase {
  constructor() {
    super("invoice", ServiceBase.getDaoName(IInvoiceService));
    let is = system.getObject("util.invoiceStatus");
    this.invoiceStatus = is.status;

    this.iinvoicesummaryinfoDao = system.getObject("db.invoice.iinvoicesummaryinfoDao");
    this.iinvoiceprocessDao = system.getObject("db.invoice.iinvoiceprocessDao");
    this.iinvoiceinforegDao = system.getObject("db.invoice.iinvoiceinforegDao");
    this.iinvoicedeliverDao = system.getObject("db.invoice.iinvoicedeliverDao");
    this.RULE_INVOICE_TYPE =["10",'20','30'];      //发票类型
    this.RULE_BUSINESSMEN_TYPE=['10','20'];      //销售方类型
    this.iproductDao = system.getObject("db.product.iproductDao");
    this.iprocessDao = system.getObject("db.product.iprocessDao");
    this.iproductprocessDao = system.getObject("db.product.iproductprocessDao");
  }

  /**
   * 发票申请
   * @param {*} params 
   */
  async invoiceApply(params){
    if(!params.channel_id ){
      return system.getResult(null,`渠道ID不能为空`);
    }
    if(!params.apply_no ){
      return system.getResult(null,`发票申请编号不能为空`);
    }
    try {
      let invoiceExists =await  this.dao.findByChannelAndApplyNo(this.trim(params.channel_id),this.trim(params.apply_no));
      if(invoiceExists.total!=0){
        return system.getResult(null,`发票编号[${params.apply_no}]已存在`);
      }  
    } catch (error) {
      console.log(error);
      return system.getResult(null,`系统错误 ${error}`);
    }
    
    if(this.RULE_INVOICE_TYPE.indexOf(this.trim(params.invoice_type)) ==-1){
      return system.getResult(null,`发票类型不存在`);
    }
    // if(!params.apply_time){
    //   return system.getResult(null,`发票申请时间错误`);
    // }
    if(!params.invoice_content){
      return system.getResult(null,`开票内容不能为空`);
    }
    if(!params.contract){
      return system.getResult(null,`合同不能为空`);
    }

    let _invoice = {};
    _invoice.channel_id = this.trim(params.channel_id);
    _invoice.apply_no = this.trim(params.apply_no);
    _invoice.invoice_type = this.trim(params.invoice_type);
    _invoice.apply_time = this.trim(params.apply_time) || new Date();
    _invoice.invoice_amount = this.trim(params.invoice_amount) || 0;
    _invoice.invoice_content = this.trim(params.invoice_content) || "服务费";
    _invoice.contract = this.trim(params.contract) || null;
    _invoice.personal_invoice_tax = this.trim(params.personal_invoice_tax) || 0 ;
    _invoice.additional_tax = this.trim(params.additional_tax) || 0 ;
    _invoice.value_added_tax = this.trim(params.value_added_tax) || 0 ;
    _invoice.product_id = params.product_id || 50010000;
    if(!params.merchant_name){
      return system.getResult(null,`购买方名称不能为空`);
    }
    if(!params.merchant_credit_code){
      return system.getResult(null,`购买方社会统一信用代码不能为空`);
    }
    if(!params.merchant_addr){
      return system.getResult(null,`购买方地址不能为空`);
    }
    if(!params.merchant_mobile){
      return system.getResult(null,`购买方电话不能为空`);
    }
    if(!params.merchant_bank){
      return system.getResult(null,`购买方开户行不能为空`);
    }
    if(!params.merchant_account){
      return system.getResult(null,`购买方对公账户不能为空`);
    }
    _invoice.merchant_id = this.trim(params.merchant_id);
    _invoice.merchant_name = this.trim(params.merchant_name);
    _invoice.merchant_credit_code = this.trim(params.merchant_credit_code);
    _invoice.merchant_addr = this.trim(params.merchant_addr);
    _invoice.merchant_mobile = this.trim(params.merchant_mobile);
    _invoice.merchant_bank = this.trim(params.merchant_bank);
    _invoice.merchant_account = this.trim(params.merchant_account);

    if(!params.businessmen_name){
      return system.getResult(null,`销售方名称不能为空`);
    }
    if(!params.businessmen_credit_code){
      return system.getResult(null,`销售方社会统一信用代码不能为空`);
    }
    if(!params.businessmen_addr){
      return system.getResult(null,`销售方地址不能为空`);
    }
    if(!params.businessmen_mobile){
      return system.getResult(null,`销售方电话不能为空`);
    }
    if(!params.businessmen_bank){
      return system.getResult(null,`销售方开户行不能为空`);
    }
    if(!params.businessmen_account){
      return system.getResult(null,`销售方对公账户不能为空`);
    }
    if(this.RULE_BUSINESSMEN_TYPE.indexOf(this.trim(params.businessmen_type)) ==-1){
      return system.getResult(null,`销售方类型错误`);
    }
    _invoice.businessmen_type = this.trim(params.businessmen_type);
    _invoice.businessmen_id = this.trim(params.businessmen_id);
    _invoice.businessmen_credit_code = this.trim(params.businessmen_credit_code) || 0;
    _invoice.businessmen_name = this.trim(params.businessmen_name);
    _invoice.businessmen_addr = this.trim(params.businessmen_addr);
    _invoice.businessmen_mobile = this.trim(params.businessmen_mobile);
    _invoice.businessmen_bank = this.trim(params.businessmen_bank);
    _invoice.businessmen_account = this.trim(params.businessmen_account);

    _invoice.mail_to = this.trim(params.mail_to) || "";
    _invoice.mail_mobile = this.trim(params.mail_mobile) || "";
    _invoice.mail_addr = this.trim(params.mail_addr) || "";

    try {

      let processList = await this.buildProcess(_invoice.product_id) || [];
      if (!processList || processList.length == 0) {
        return system.getResult(null, "产品流程未配置");
      }
      _invoice.status = processList[0].status;

      await this.db.transaction(async t => {
        _invoice = await this.dao.create(_invoice,t);
        await this.iinvoiceinforegDao.create({id:_invoice.id},t); 
        await this.iinvoicesummaryinfoDao.create({id:_invoice.id},t); 

        for(let process of processList) {
          process.invoice_id = _invoice.id;
        }
        await this.iinvoiceprocessDao.model.bulkCreate(processList, { transaction: t });
      });
      return system.getResult(`success`);
    } catch (error) {
      console.log(error);
      return system.getResult(null,`系统错误`);
    }
  }
  
  async invoicePage(params) {
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);
    params.startRow = Number((params.currentPage - 1) * params.pageSize);

    let total = await this.dao.countByParams(params);
    if (total == 0) {
      return { count: 0, rows: [] };
    }

    let list = await this.dao.pageByParams(params);
    if (list) {
      for (var item of list) {
        this.handleDate(item, ['updated_at', 'created_at'], 'YYYY-MM-DD HH:mm:ss');
      }
      //格式化产品
      await this.setDeliver(list);
      //格式化业务员
      await this.setStatus(list);

      await this.setProduct(list);
    }
    return { count: total, rows: list };
  }

  /**
   * 格式化产品
   * @param {*} list
   */
  async setProduct(list) {
    let productIdList = [];
    for (let item of list) {
      if (item.product_id) {
        productIdList.push(item.product_id);
      }
    }
    if(!productIdList || productIdList.length === 0) {
      return;
    }
    let productMap = await this.iproductDao.mapByIds(productIdList);
    for (let item of list) {
      item.oproduct = productMap[item.product_id] || {}
    }
  }

  async setDeliver(list) {
    if (!list || list.length == 0) {
      return;
    }

    let ids = [];
    for (let item of list) {
      if (!item.invoice_deliver_id) {
        continue;
      }
      ids.push(item.invoice_deliver_id)
    }
    if(!ids || ids.length === 0) {
      return;
    }

    let map = await this.iinvoicedeliverDao.findMapByIds(ids);
    for (let item of list) {
      item.invoice_deliver = map[item.invoice_deliver_id] || {};
    }
  }

  /**
   * 处理状态数据
   * @param list
   * @returns {Promise<void>}
   */
  async setStatus(list) {
    let ids = [];
    let statuses = [];
    for (let item of list) {
      ids.push(item.id);
      statuses.push(item.status);
    }

    if(!ids || ids.length === 0 || !statuses || statuses.length === 0) {
      return;
    }

    let map = await this.iinvoiceprocessDao.mapByInvoiceIdsAndStatus(ids, statuses);
    for (let item of list) {
      let key = item.id + "_" + item.status;
      let v = map[key] || {};
      item.status_name = v.name;
      item.next_status = JSON.parse(v.next_status || "[]");
    }
    console.log(list);
  }

  /**
   * 构建产品流程对象
   * @param productPid
   * @param chooseProductIds
   * @returns {Promise<void>}
   */
  async buildProcess(productPid) {
    productPid = productPid || 50010000;
    // 查询产品流程
    let productProcessList = await this.iproductprocessDao.byProductPid(productPid);
    if (!productProcessList || productProcessList.length == 0) {
      return [];
    }

    let invoiceProcessList = [];
    // 批量查流程
    let processMap = await this.iprocessDao.mapAll();

    for (let productProcess of productProcessList) {
      // 风还钻该处理每一个子项流程 变为 订单流程对象
      let process = processMap[productProcess.process_id];
      let nextArr = this.trim(productProcess.next_status).split(",");
      let nextStatus = [];
      for (let nextId of nextArr) {
        nextId = Number(nextId || 0);
        let nextObj = processMap[nextId];
        if (!nextObj) {
          continue;
        }
        nextStatus.push({ next_status: nextObj.status, next_name: nextObj.name });
      }

      let orderProcess = {
        product_id: productPid,
        name: process.name,
        status: process.status,
        func: productProcess.func,
        next_status: JSON.stringify(nextStatus),
        name1: productProcess.name1,
        name2: productProcess.name2,
        name3: productProcess.name3,
        name4: productProcess.name4,
        sort: productProcess.sort,
        autoIncrement: true
      };
      invoiceProcessList.push(orderProcess);
    }

    return invoiceProcessList;
  }

}
module.exports = IInvoiceService;
