'use strict'
/**
 * 流程表
 */
module.exports = function (db, DataTypes) {
	return db.define('iprocess', {
		name: { type: DataTypes.STRING, field: 'name', allowNull: false, defaultValue: '', comment: '流程名称' },
		status: { type: DataTypes.STRING, field: 'status', allowNull: false, defaultValue: '', comment: '流程状态' },
		created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
		updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
		deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true }
	},
	{
		timestamps: true,
		underscore: true,
		paranoid: true,
		version: true,
		tableName: 'i_process',
		comment: '发票产品流程表',
	});
}

