'use strict'
/**
 * 流程表
 */
module.exports = function (db, DataTypes) {
	return db.define('iinvoicesummaryinfo', {
		province: { type: DataTypes.STRING(10), allowNull: true, comment: "发票对应省份" },
    invoice_type: { type: DataTypes.STRING(4), allowNull: true, comment: '发票类型 10 增值税专用发票 20 增值税普通发票 30 普通发票' },
    invoice_join: { type: DataTypes.STRING(4), allowNull: true, comment: '发票联次 10 记账联 20 发票联 30 抵扣联 40 销售方次' },
    invoice_no: { type: DataTypes.STRING(20), allowNull: true,delaultValue:"", comment: "发票代码" },
    invoice_number: { type: DataTypes.STRING(20), allowNull: true,delaultValue:"", comment: "发票号码" },
    invoice_time: { type: DataTypes.DATE, allowNull: true, delaultValue:null,comment: "开票日期" },

		merchant_name: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方名称' },
    merchant_credit_code: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方纳税人识别号' },
    merchant_addr: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方地址' },
    merchant_mobile: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方电话' },
    merchant_bank: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '购买方开户行' },
		merchant_account: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '银行账号' },
		
		businessmen_credit_code: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方社会统一信用代码' },
    businessmen_name: { type: DataTypes.STRING(45), allowNull: true, defaultValue: "" },
    businessmen_addr: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方地址' },
    businessmen_mobile: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方电话' },
    businessmen_bank: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方开户行' },
		businessmen_account: { type: DataTypes.STRING(45), allowNull: false, COMMENT: '销售方银行账号' },
		
		summary:{ type: DataTypes.TEXT,  allowNull: true, defaultValue:"",comment: '发票摘要'},
		created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
		updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
		deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
	},
	{
		timestamps: false,
		underscore: true,
		paranoid: true,
		version: true,
		tableName: 'i_invoice_summary_info',
		comment: '发票平台交付详情',
	});
}