'use strict'
/**
 * 流程表
 */
module.exports = function (db, DataTypes) {
	return db.define('iinvoiceinforeg', {
		// invoice_id: { type: DataTypes.STRING, allowNull: true, comment: '订单号' },
		deliver_id: { type: DataTypes.STRING, allowNull: true, comment: '交付商id' },
		deliver_name: { type: DataTypes.STRING, allowNull: true, comment: '交付商名称' },
		deliver_divide: { type: DataTypes.BIGINT, allowNull: true, comment: '订单分成' },
		deliver_mail_addr: { type: DataTypes.STRING, allowNull: true, comment: '交付地址' },
		deliver_mail_to: { type: DataTypes.STRING, allowNull: true, comment: '收件人' },
		deliver_mail_mobile: { type: DataTypes.STRING, allowNull: true, comment: '联系电话' },
		audit_content: { type: DataTypes.STRING, allowNull: true, comment: '交付审核内容 /审核备注' },
		deliver_content: { type: DataTypes.STRING, allowNull: true, comment: '交付内容' },
		deliver_mail_no: { type: DataTypes.STRING, allowNull: true, comment: '交付商交付快递单号' },
		deliver_img: { type: DataTypes.STRING, allowNull: true, comment: '交接单' },
		// operator_id: { type: DataTypes.INTEGER, allowNull: true, comment: '交付商业务员id' },
		audit_result: { type: DataTypes.STRING, field: 'audit_result', allowNull: true,defaultValue:'', comment:'审核结果'},
		created_at: { type: DataTypes.DATE, field: 'created_at', allowNull: false, defaultValue: DataTypes.NOW },
		updated_at: { type: DataTypes.DATE, field: 'updated_at', allowNull: false, defaultValue: DataTypes.NOW },
		deleted_at: { type: DataTypes.DATE, field: 'deleted_at', allowNull: true },
	},
	{
		timestamps: false,
		underscore: true,
		paranoid: true,
		version: true,
		tableName: 'i_invoice_info_reg',
		comment: '发票平台交付详情',
	});
}