const Dao = require("../../dao.base");
const system = require("../../../system");
class IinvoicedeliverDao extends Dao {
  constructor() {
    super(Dao.getModelName(IinvoicedeliverDao));
  }

  async findMapByIds(ids) {
    var result = {};
    var sql = `SELECT * FROM ${this.model.tableName} WHERE id IN (:ids)`;
    var list = await this.customQuery(sql, {
      ids: ids
    });
    if (!list || list.length == 0) {
      return result;
    }
    for (var item of list) {
      result[item.id] = item;
    }
    return result;
  }

  async countByParams(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) as total");
    sql.push("FROM i_invoice_deliver t2");
    sql.push("INNER JOIN i_invoice t1 on t1.id = t2.invoice_id");
    sql.push("WHERE 1 = 1 ");

    this.setCondition(params, sql);

    var counts = await this.customQuery(sql.join(" "), params);
    if (!counts || counts.length == 0) {
      return 0;
    }
    return counts[0].total || 0;
  }

  async pageByParams(params, startRow, pageSize) {
    var sql = [];
    sql.push("SELECT");
    sql.push("t1.`product_id`, ");
    sql.push("t1.`apply_no`, t1.`invoice_type`, t1.`invoice_join`, t1.`invoice_amount`, ");
    sql.push("t1.`apply_time`, t1.invoice_time, t1.`created_at`, t1.`status`, ");
    sql.push("t1.`merchant_name`, t1.businessmen_name");
    sql.push("FROM i_invoice_deliver t2");
    sql.push("INNER JOIN i_invoice t1 on t1.id = t2.invoice_id");
    sql.push("WHERE 1 = 1 ");

    this.setCondition(params, sql);

    sql.push("ORDER BY t2.id DESC");
    sql.push("LIMIT :startRow, :pageSize");
    params.startRow = startRow || 0;
    params.pageSize = pageSize || 10;
    return await this.customQuery(sql.join(" "), params);
  }

  setCondition(params, sql) {
    if (params.apply_no) {
      sql.push("AND t1.`apply_no` = :apply_no");
    }
    if (params.status) {
      sql.push("AND t1.`status` = :status");
    }
    if (params.statuses && params.statuses.length > 0) {
      sql.push("AND t1.`status` in (:statuses)");
    }
    if (params.invoice_type) {
      sql.push("AND t1.`invoice_type` = :invoice_type");
    }
    if (params.invoiceTimeBegin) {
      sql.push("AND t1.`invoice_time` >= :invoiceTimeBegin");
    }
    if (params.invoiceTimeEnd) {
      sql.push("AND t1.`invoice_time` <= :invoiceTimeEnd");
    }
    if (params.red_status) {
      sql.push("AND t1.`red_status` = :red_status");
    }
    if (params.deliver_id) {
      sql.push("AND t1.`deliver_id` = :deliver_id");
    }
    if (params.bd_id) {
      sql.push("AND t1.`bd_id` = :bd_id");
    }
    if (params.bd_path) {
      params.bd_path_like = params.bd_path + "%";
      sql.push("AND t1.`bd_path` = :bd_path_like");
    }

    if (params.operator_id) {
      sql.push("AND t2.`operator_id` = :operator_id");
    }
  }

  // //交付商业务概览
  // async countStat(params) {
  //   var sql = [];
  //   sql.push("select distinct deliverer_id from `xgg-invoice`.invoice_deliverer where 1=1");
  //   this.setCondition(params, sql);

  //   var list = await this.customQuery(sql.join(" "), params);
  //   return {
  //     total: list.length || 0,
  //     list: list
  //   };
  // }

  // setCondition(params, sql) {
  //   if (params.begin) {
  //     sql.push("AND created_at >= :begin");
  //   }
  //   if (params.end) {
  //     sql.push("AND created_at <= :end");
  //   }
  // }
  // //获取名字 id等信息
  // async queryStat(params, startRow, pageSize) {
  //   var sql = [];
  //   sql.push("SELECT");
  //   sql.push("b.id, b.deliverer_id, b.deliverer_name,sum(b.deliverer_amount) as totalAmount");
  //   sql.push("FROM invoice_deliverer b inner join invoice_apply a on a.deliverer_id=b.id ");
  //   sql.push("WHERE 1 = 1 and b.deliverer_id in (" + params.list + ")");

  //   if (params.begin) {
  //     sql.push("AND b.created_at >= :begin");
  //   }
  //   if (params.end) {
  //     sql.push("AND b.created_at <= :end");
  //   }
  //   sql.push("GROUP BY b.deliverer_id");
  //   sql.push("LIMIT :startRow, :pageSize");

  //   params.startRow = startRow;
  //   params.pageSize = pageSize;
  //   var list = await this.customQuery(sql.join(" "), params);
  //   return list;
  // }

  // async statDeliverByStatus(params) {
  //   var sql = [];
  //   sql.push("SELECT");
  //   sql.push("a.deliverer_id,a.status,COUNT(1) AS invoiceCount");
  //   sql.push("FROM `invoice_apply` a inner join `invoice_deliverer` b  on a.deliverer_id=b.id");
  //   sql.push("WHERE 1 = 1");

  //   if (params.delivererIds) {
  //     sql.push("AND a.deliverer_id IN (:delivererIds)")
  //   }
  //   if (params.begin) {
  //     sql.push("AND b.created_at >= :begin");
  //   }
  //   if (params.end) {
  //     sql.push("AND b.created_at <= :end");
  //   }
  //   sql.push("GROUP BY a.`status`");

  //   var result = {};
  //   var list = await this.customQuery(sql.join(" "), params);
  //   if (!list || list.length == 0) {
  //     return result;
  //   }

  //   for (var item of list) {
  //     result[item.deliverer_id + "_" + item.status] = item.invoiceCount || 0;
  //   }
  //   return result;
  // }

  // //按天来计算（交付商）
  // async delStatDayByTime(begin, end, delivererId) {
  //   var result = {};
  //   var sql = [];
  //   sql.push("SELECT");
  //   sql.push("DATE_FORMAT(created_at, '%Y-%m-%d') AS `day`, SUM(deliverer_amount) AS delivererAmount, COUNT(1) AS invoiceCount");
  //   sql.push("FROM `invoice_deliverer`");
  //   sql.push("WHERE 1 = 1");

  //   var params = {
  //     begin: begin,
  //     end: end,
  //     delivererId: delivererId
  //   };
  //   if (begin) {
  //     sql.push("AND created_at >= :begin");
  //   }
  //   if (end) {
  //     sql.push("AND created_at <= :end");
  //   }
  //   if (delivererId) {
  //     sql.push("AND deliverer_id = :delivererId");
  //   }
  //   sql.push("GROUP BY `day` ORDER BY `day` ASC");
  //   var list = await this.customQuery(sql.join(" "), params);

  //   if (!list || list.length == 0) {
  //     return result;
  //   }
  //   for (var item of list) {
  //     result[item.day] = item;
  //   }
  //   return result;
  // }

  // //安月来计算（交付商）
  // async delStatMonthByTime(begin, end, delivererId) {
  //   var result = {};
  //   var sql = [];
  //   sql.push("SELECT");
  //   sql.push("DATE_FORMAT(created_at, '%Y-%m') AS `month`, SUM(deliverer_amount) AS delivererAmount, COUNT(1) AS invoiceCount");
  //   sql.push("FROM `invoice_deliverer`");
  //   sql.push("WHERE 1 = 1");

  //   var params = {
  //     begin: begin,
  //     end: end
  //   };
  //   if (begin) {
  //     sql.push("AND created_at >= :begin");
  //   }
  //   if (end) {
  //     sql.push("AND created_at <= :end");
  //   }
  //   if (delivererId) {
  //     sql.push("AND deliverer_id = :delivererId");
  //   }
  //   sql.push("GROUP BY `month` ORDER BY `month` ASC");
  //   var list = await this.customQuery(sql.join(" "), params);

  //   if (!list || list.length == 0) {
  //     return result;
  //   }

  //   for (var idx = 0; idx < list.length; idx++) {
  //     var item = list[idx];
  //     result[item.month] = item;

  //     if (idx == 0) {
  //       result.begin = item.month;
  //     }

  //     if (idx == list.length - 1) {
  //       result.end = item.month;
  //     }
  //   }
  //   return result;
  // }


  // async delStatInvoiceByTime(begin, end, delivererId) {
  //   var sql = [];
  //   sql.push("SELECT");
  //   sql.push("COUNT(1) AS invoiceCount, SUM(deliverer_amount) AS delivererAmount");
  //   sql.push("FROM `invoice_deliverer`");
  //   sql.push("WHERE 1 = 1");

  //   var params = {
  //     begin: begin,
  //     end: end,
  //     delivererId: delivererId
  //   };
  //   if (begin) {
  //     sql.push("AND created_at >= :begin");
  //   }
  //   if (end) {
  //     sql.push("AND created_at <= :end");
  //   }
  //   if (delivererId) {
  //     sql.push("AND deliverer_id = :delivererId");
  //   }
  //   var list = await this.customQuery(sql.join(" "), params);

  //   if (!list || list.length == 0) {
  //     return {
  //       invoiceCount: 0,
  //       delivererAmount: 0,
  //     }
  //   }
  //   var item = list[0];
  //   return {
  //     invoiceCount: item.invoiceCount || 0,
  //     delivererAmount: item.delivererAmount || 0,
  //   }
  // }

  // /**
  //  * 发票办理
  //  * @param {*} begin 
  //  * @param {*} end 
  //  */
  // async delStatByStatus(begin, end) {
  //   var sql = [];
  //   sql.push("SELECT");
  //   sql.push("`status`, COUNT(1) AS invoiceCount ");
  //   sql.push("FROM `invoice_deliverer`");
  //   sql.push("WHERE 1 = 1");
  //   var params = {
  //     begin: begin,
  //     end: end
  //   };

  //   if (begin) {
  //     sql.push("AND created_at >= :begin");
  //   }
  //   if (end) {
  //     sql.push("AND created_at <= :end");
  //   }

  //   sql.push("GROUP BY `status`");

  //   var result = {};
  //   var list = await this.customQuery(sql.join(" "), params);
  //   if (!list || list.length == 0) {
  //     return result;
  //   }

  //   for (var item of list) {
  //     result[item.status] = item.invoiceCount || 0;
  //   }
  //   return result;
  // }

  // /**
  //  * 发票申请表（交付商）
  //  */
  // async countApplyByParams(params) {
  //   let sql = [];
  //   sql.push(`select count(1) as count from invoice_deliverer b  inner join invoice_apply a 
  //   on b.id = a.deliverer_id inner join invoice c on c.id = b.invoice_id where 1=1 `);
  //   this.setParams(sql, params);
  //   return await this.customQuery(sql.join(" "),params);
  // }

  // /**
  //  * 发票列表（交付商）
  //  */
  // async countInvoiceByParams(params) {
  //   let sql = [];
  //   sql.push(`select count(1) as count from invoice_apply a inner join invoice c on a.id=c.id
  //   inner join invoice_deliverer b on a.deliverer_id = b.id  where 1=1 `);
  //   this.setParams(sql, params);
  //   if (params.status) {
  //     sql.push(`and c.status = :status`);
  //   }else{
  //     sql.push(` and c.status in('1070','1080','1090')`);
  //   }
  //   return await this.customQuery(sql.join(" "),params);
  // }

  // /**
  //  * 发票申请列表
  //  * @param {*} params 
  //  */
  // async delivererApplyInvoices(params) {
  //   let sql = [];
  //   sql.push(`select a.id, a.apply_no,a.type,a.invoice_amount,a.invoice_time,c.status,a.merchant_name,a.businessmen_name  
  //   from invoice_deliverer b  inner join invoice_apply a on b.id = a.deliverer_id
  //   inner join invoice c on c.id = b.invoice_id where 1=1 `);
  //   this.setParams(sql, params);
  //   sql.push(`order by id desc limit ${params.statRow},${params.pageSize}`);
  //   return await this.customQuery(sql.join(" "),params);
  // }

  // /**
  //  * 发票列表
  //  * @param {*} params 
  //  */
  // async delivererInvoices(params) {
  //   let sql = [];
  //   sql.push(`select a.id, a.apply_no,a.type,c.invoice_no,c.invoice_time,a.invoice_amount,a.merchant_id,a.merchant_name,
  //   a.merchant_credit_code,a.merchant_addr,a.merchant_mobile,a.merchant_bank,a.merchant_account,a.businessmen_id,
  //   a.businessmen_credit_code,a.businessmen_name,a.businessmen_addr,a.businessmen_mobile,a.businessmen_bank,
  //   a.businessmen_account,a.is_bank,a.tax_authoritioes,a.is_invalid,c.complate_tax, c.status,c.red_status from invoice_apply a 
  //   inner join invoice c on a.id=c.id inner join invoice_deliverer b on b.id = a.deliverer_id where 1=1 `);
  //   this.setParams(sql, params);
  //   if (params.status) {
  //     sql.push(` and c.status = :status`);
  //   }else{
  //     sql.push(` and c.status in('1070','1080','1090')`);
  //   }
  //   sql.push(`order by id desc limit ${params.statRow},${params.pageSize}`);
  //   return await this.customQuery(sql.join(" "),params);
  // }

  // setParams(sql, params) {
  //   if (params.delivererId) {
  //     sql.push(` AND b.deliverer_id = :delivererId`);
  //   }
  //   if (params.applyNo) {
  //     sql.push(` AND a.apply_no = :applyNo`);
  //   }
  //   if (params.invoiceNo) {
  //     sql.push(` AND c.invoice_no = :invoiceNo`);
  //   }
  //   if (params.startTime) {
  //     sql.push(`and a.invoice_time >= :startTime`);
  //   }
  //   if (params.endTime) {
  //     sql.push(`and a.invoice_time <= :endTime`);
  //   }
  //   if(params.invoiceTime){
  //     sql.push(`and a.invoice_time >= :invoiceTime`);
  //   }
  //   if (params.type) {
  //     sql.push(`and a.type = :type`);
  //   }
  //   if (params.status) {
  //     sql.push(`and c.status = :status`);
  //   }
  // }
}
module.exports = IinvoicedeliverDao;
