const system = require("../../../system");
const Dao = require("../../dao.base");
const moment = require("moment");
class IInvoiceDao extends Dao {
  constructor() {
    super(Dao.getModelName(IInvoiceDao));
  }
  async countByParams(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("COUNT(1) as total");
    sql.push("FROM `i_invoice` t1");
    sql.push("WHERE 1 = 1 ");

    this.setCondition(params, sql);

    var counts = await this.customQuery(sql.join(" "), params);
    if(!counts || counts.length == 0) {
      return 0;
    }
    return counts[0].total || 0;
  }

  async pageByParams(params) {
    var sql = [];
    sql.push("SELECT");
    sql.push("t1.*");
    sql.push("FROM `i_invoice` t1");
    sql.push("WHERE 1 = 1 ");

    this.setCondition(params, sql);

    sql.push("ORDER BY t1.id DESC");
    sql.push("LIMIT :startRow, :pageSize");
    return await this.customQuery(sql.join(" "), params);
  }

  setCondition(params, sql) {
    if(params.apply_no) {
      sql.push("AND t1.`apply_no` = :apply_no");
    }
    if(params.status) {
      sql.push("AND t1.`status` = :status");
    }
    if(params.statuses && params.statuses.length > 0){
      sql.push("AND t1.`status` in (:statuses)");
    }
    if(params.invoice_type) {
      sql.push("AND t1.`invoice_type` = :invoice_type");
    }
    if(params.createTimeBegin) {
      sql.push("AND t1.`created_at` >= :createTimeBegin");
    }
    if(params.createTimeEnd) {
      sql.push("AND t1.`created_at` <= :createTimeEnd");
    }

    if(params.red_status) {
      sql.push("AND t1.`red_status` = :red_status");
    }
    if(params.deliver_id) {
      sql.push("AND t1.`deliver_id` = :deliver_id");
    }
    if(params.bd_id) {
      sql.push("AND t1.`bd_id` = :bd_id");
    }
    if(params.bd_path) {
      params.bd_path_like = params.bd_path + "%";
      sql.push("AND t1.`bd_path` = :bd_path_like");
    }
  }

  async findByChannelAndApplyNo(channel_id,apply_no){
    let sql =`select count(1) as total from i_invoice where channel_id = "${channel_id}" and apply_no = "${apply_no}"`;
    var counts = await this.customQuery(sql);
    return counts[0];
  }

  // /**
  //  * 红冲列表总计
  //  * @param {*} params 
  //  */
  // async countRedRushListByParams(params){
  //   var sql = [];

  //   sql.push(`select count(1) as count from invoice_apply a inner join invoice_deliverer b on a.deliverer_id =b.id 
  //   inner join invoice c on b.invoice_id =c.id where a.id = c.id  `);

  //   if (params.delivererId) {
  //     sql.push(` AND b.deliverer_id = :delivererId`);
  //   }
  //   if (params.applyNo) {
  //     sql.push(` AND a.apply_no = :applyNo`);
  //   }
  //   if (params.invoiceNo) {
  //     sql.push(` AND c.invoice_no = :invoiceNo`);
  //   }
  //   if (params.startTime) {
  //     sql.push(`and a.invoice_time >= :startTime`);
  //   }
  //   if (params.endTime) {
  //     sql.push(`and a.invoice_time <= :endTime`);
  //   }
  //   if(params.invoiceTime){
  //     sql.push(`and a.invoice_time >= :invoiceTime`);
  //   }
  //   if (params.type) {
  //     sql.push(`and a.type = :type`);
  //   }
  //   if (params.redStatus) {
  //     sql.push(`and c.red_status = :redStatus`);
  //   }
  //   if (params.status) {
  //     sql.push(`and c.status = :status`);
  //   }
  //   return await this.customQuery(sql.join(" "), params);
  // }

  // /**
  //  * 红冲列表
  //  * @param {*} params 
  //  */
  // async redRushListByParams(params){
  //   var sql = [];
  //   sql.push(`select a.apply_no,a.type,a.invoice_amount,a.invoice_time,c.status,
  //   a.merchant_name,a.businessmen_name,a.id,b.deliverer_id from invoice_apply a 
  //   inner join invoice_deliverer b on a.deliverer_id =b.id 
  //   inner join invoice c on b.invoice_id =c.id where a.id = c.id  `);

  //   if (params.delivererId) {
  //     sql.push(` AND b.deliverer_id = :delivererId`);
  //   }
  //   if (params.applyNo) {
  //     sql.push(` AND a.apply_no = :applyNo`);
  //   }
  //   if (params.startTime) {
  //     sql.push(`and a.invoice_time >= :startTime`);
  //   }
  //   if (params.endTime) {
  //     sql.push(`and a.invoice_time <= :endTime`);
  //   }
  //   if(params.invoiceTime){
  //     sql.push(`and a.invoice_time >= :invoiceTime`);
  //   }
  //   if (params.type) {
  //     sql.push(`and a.type = :type`);
  //   }
  //   if (params.redStatus) {
  //     sql.push(`and c.red_status = :redStatus`);
  //   }
  //   sql.push("ORDER BY c.id DESC");
  //   sql.push("LIMIT :statRow, :pageSize");
  //   return await this.customQuery(sql.join(" "), params);
  // }
}
module.exports = IInvoiceDao;