const system = require("../../../system");
const ServiceBase = require("../../svems.base")
class RoleService extends ServiceBase {
  constructor() {
    super();
  }
    /**
   * 角色  添加 
   * @param {*} params 
   */
  async addRole(params) {
    try {
      return await this.callms("uc", "addRole", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 角色  更新
   * @param {*} params 
   */
  async updRole(params) {
    try {
      return await this.callms("uc", "updRole", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 角色 删除 
   * @param {*} params 
   */
  async delRole(params) {
    try {
      return await this.callms("uc", "delRole", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * 角色  查询列表 
   * @param {*} params 
   */
  async listRole(params) {
    try {
      return await this.callms("uc", "listRole", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 角色  查询明细
   * @param {*} params 
   */
  async queryById(params) {
    try {
      return await this.callms("uc", "roleQueryById", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async setAuth(params) {
    try {
      return await this.callms("uc", "setAuth", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = RoleService;