var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const uuidv4 = require('uuid/v4');
var moment = require("moment");
var svgCaptcha = require('svg-captcha');

class DeliverCtl extends CtlBase {
  constructor() {
    super();
    this.deliverSve = system.getObject("service.common.deliverSve");
  }

  async all(pobj, pobj2, req) {
    try {
      return await this.deliverSve.all(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async page(pobj, pobj2, req) {
    try {
      return await this.deliverSve.page(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async info(pobj, pobj2, req) {
    try {
      return await this.deliverSve.info(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async save(pobj, pobj2, req) {
    try {
      return await this.deliverSve.save(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async del(pobj, pobj2, req) {
    try {
      return await this.deliverSve.del(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

}
module.exports = DeliverCtl;