{
  template: '${tmpl}',
    data: function() {
      return {
        multipleSelection: [],
        isSingleSelect: false,
      }
    },
  mounted: function() {

  },
  created: function() {
  },
  methods: {
    onselchange(prop, formModel, target){
      target[0].setrefwhere2({ pid: formModel[prop] });
    },
    calcservicepricemethod(){
      var model = null;
      var publicExpense = 0;
      var serviceCharge = 0;
      var rateConfig = 0;
      var discountsRateConfig = 0;
      model = this.$refs.grd2.getFormModel();
      serviceCharge = Number(model.serviceCharge ? model.serviceCharge : 0);
      if (isNaN(serviceCharge)) {
        throw new Error("请输入数字");
      }
      if (serviceCharge < 0) {
        throw new Error("服务费不能小于0");
      }
      publicExpense = Number(model.publicExpense ? model.publicExpense : 0);
      if (isNaN(publicExpense)) {
        throw new Error("请输入数字");
      }
      rateConfig = Number(model.rateConfig ? model.rateConfig : 0) / 100;
      if (isNaN(rateConfig)) {
        throw new Error("请输入数字");
      }
      discountsRateConfig = Number(model.discountsRateConfig ? model.discountsRateConfig : 0) / 100;
      if (isNaN(discountsRateConfig)) {
        throw new Error("请输入数字");
      }
      if (rateConfig < 0 || rateConfig > 1) {
        throw new Error("请输入1-100之间的数字");
      }
      if (discountsRateConfig < 0 || discountsRateConfig > 1) {
        throw new Error("请输入1-100之间的数字");
      }
      model.price = publicExpense + serviceCharge;
      model.discountAmount = (model.price * discountsRateConfig).toFixed(2);
      console.log(model.discountAmount);
    },
    vfmethod: function(rule, value, callback) {
      if (rule.field == "serviceCharge" || rule.field == "publicExpense" || rule.field == "discountsRateConfig") {
        try {
          this.calcservicepricemethod();
        } catch (e) {
          return callback(e);
        }
      }
      if (rule.field == "discountsRateConfig") {
        if (isNaN(value)) {
          return callback(new Error("请输入数字"));
        }
        if (Number(value) > 100 || Number(value) < 0) {
          return callback(new Error("请输入1-100之间的数字"));
        }
      }
      if (rule.field == "channelProfitRate") {
        if (isNaN(value)) {
          return callback(new Error("请输入数字"));
        }
        if (Number(value) > 100 || Number(value) < 0) {
          return callback(new Error("请输入1-100之间的数字"));
        }
      }
      return callback();
    },
    onColFormater(row, column, cellvalue, index){
      if (column.property == "isPubed") {
        if (row["isPubed"]) {
          return "是";
        } else {
          return "否";
        }
      }
      return cellvalue;
    },
    handleSelectionChange: function(val) {
      this.multipleSelection = val;
      console.log(val);
    },
    onRowClick(row, key, e){
      if (key == "stopUser") {

      }
    },
    beforeedit(row){
      var p = Number(row.price ? row.price : 0);
      var dr = Number(row.discountsRateConfig ? row.discountsRateConfig : 0) / 100;
      var discountAmount = (row.price * dr).toFixed(2);
      this.$set(row, "discountAmount", discountAmount);
    },
  },
  computed: Vuex.mapState({
    count: state => state.count,
    headStyle: function () {
      return { "background-color": "white" };
    }
  }),
    vname: "gsb_productcrud"
}
