const system=require("../../system");
const ServiceBase=require("../sve.base");
class TransactionspecialperformanceService extends ServiceBase{
    constructor(){
        super(ServiceBase.getDaoName(TransactionspecialperformanceService));
        
    }
    async changePublishStatus(obj){
        var user = obj.user;
        var ids = obj.ids;
        var status = obj.status;
        if(!ids || ids.length<1){
            return {code:-1,msg:"ids参数错误"};
        }
        if(status==null || status==undefined){
            return {code:-2,msg:"status参数错误"};
        }
        await this.dao.model.update({isReleased:status}, { where: { id: { [this.dao.db.Op.in]: ids }} });
        return {code:1};

    }
    //获取专场数据(通过站点主题)
    async getSpecialPerformanceBySiteTheme(obj){
        var limit = obj.limit || 4;
        var siteTheme = obj.siteTheme;
        var company_id = obj.company_id;
        if(!limit){
            return {code:-1,msg:"limit参数错误"};
        }
        if(!siteTheme){
            return {code:-2,msg:"siteTheme参数错误"};
        }
        if(!company_id){
            return {code:-3,msg:"company_id参数错误"};
        }
        limit=Number(limit);
        company_id = Number(company_id);
        var sps = await this.dao.model.findAll({
            where:{createcompany_id:company_id,siteTheme:siteTheme,isReleased:1},
            limit:limit,
            offset:0,
            raw:true,
            order: [["orderNo", "asc"]]
        });
        if(!sps || sps.length<1){
            sps = await this.dao.model.findAll({
                where:{createcompany_id:1,siteTheme:siteTheme,isReleased:1},
                limit:limit,
                offset:0,
                raw:true,
                order: [["orderNo", "asc"]]
            });
        }
        for(var i=0;i<sps.length;i++){
            if(sps[i].ncl_one_codes){
               var nclonecodes = sps[i].ncl_one_codes.split(",");
               sps[i]["nclonecodes"] = nclonecodes;
            }
        }
        return {code:1,data:sps};
    }
}
module.exports=TransactionspecialperformanceService;
