const system = require("../../system");
const ServiceBase = require("../sve.base");
const logCtl = system.getObject("web.oplogCtl");
class TlOrderService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(TlOrderService));
    this.companypayparamDao = system.getObject("db.companypayparamDao");
    this.utilstlbankSve = system.getObject("service.utilstlbankSve");
  }
  async getQrCodeInfoTl(obj) {//获取通联支付二维码
    var reqKey = obj.req_key;//验证key
    if (!reqKey || reqKey != "sygyqbpogszc") {
      return { code: -80, msg: "req_key参数信息有误" }
    }

    var orderNo = obj.orderNo || "";
    var comanyId = obj.company_id;
    var otherComanyId = obj.other_company_id;
    var opType = obj.op_type;//wx，alipay

    if (!orderNo || !comanyId || !otherComanyId || !opType) {
      return { code: -100, msg: "参数信息有误" }
    }
    var orderInfo = await this.dao.findItemByOrderNo(orderNo);
    if (!orderInfo) {
      // return { code: -120, msg: "订单信息有误" }
      orderInfo = {
        orderNo: orderNo,
        busPayOrderCode: orderNo,
        wxPayOrderCode: orderNo,
        aliPayOrderCode: orderNo,
        orderPayStatus: "wfk",
        company_id: 1,
        other_company_id: otherComanyId
      }
      await this.create(orderInfo);
    }
    if (orderInfo.orderPayStatus == "yfk") {
      return { code: -130, msg: "订单已支付，请勿重复付款" }
    }
    if (orderInfo.busPayOrderCode != orderInfo.wxPayOrderCode) {
      var wxPayStatus = await this.utilstlbankSve.queryOrder(orderInfo.company_id, orderInfo.wxPayOrderCode);
      if (wxPayStatus && wxPayStatus.code == 1 && wxPayStatus.data.trxstatus == "0000") {
        return { code: -140, msg: "订单已支付，请勿重复付款" }
      }
    }
    if (orderInfo.busPayOrderCode != orderInfo.aliPayOrderCode) {
      var aliPayStatus = await this.utilstlbankSve.queryOrder(orderInfo.company_id, orderInfo.aliPayOrderCode);
      if (aliPayStatus && aliPayStatus.code == 1 && aliPayStatus.data.trxstatus == "0000") {
        return { code: -150, msg: "订单已支付，请勿重复付款" }
      }
    }
    var tmpOrderNum = orderNo + "_" + otherComanyId.toString();
    var tResult = await this.utilstlbankSve.getQrCode(orderInfo.company_id, tmpOrderNum, obj.totalSum * 100,
      obj.sveItemCode, obj.sveItemName, obj.create_ip, opType);
    //更新支付类型流水号
    var isPut = 0;
    var setField = {};
    if (opType == "wx") {
      if (tResult.code == 1 && tResult.data.trxid != orderInfo.wxPayOrderCode) {
        setField.wxPayOrderCode = tResult.data.trxid;
        orderInfo.wxPayOrderCode = tResult.data.trxid;
        isPut = 1;
      }
    } else {
      //支付宝
      if (tResult.code == 1 && tResult.data.trxid != orderInfo.aliPayOrderCode) {
        setField.aliPayOrderCode = tResult.data.trxid;
        orderInfo.aliPayOrderCode = tResult.data.trxid;
        isPut = 1;
      }
    }
    if (isPut > 0) {
      await this.updateByWhere(setField, { where: { orderNo: orderNo } });
      //充值下单成功后初始化业务锁
      await this.cacheManager["ZxPayLocker"].init(tResult.data.trxid);
    }
    tResult.data.wxPayOrderCode = orderInfo.wxPayOrderCode;
    tResult.data.aliPayOrderCode = orderInfo.aliPayOrderCode;
    return tResult;
  }
  async checkPayStatusTl(obj) {//通联支付状态验证
    var reqKey = obj.req_key;//验证key
    if (!reqKey || reqKey != "sygyqbpogszc") {
      return { code: -80, msg: "req_key参数信息有误" }
    }
    try {
      var wxPayOrderCode = obj.wxPayOrderCode || "";
      var aliPayOrderCode = obj.aliPayOrderCode || "";
      var comanyId = obj.company_id;
      var opType = obj.op_type;
      var orderNo = obj.orderNo;
      if (!wxPayOrderCode || !aliPayOrderCode || !comanyId || !opType || !orderNo) {
        return { code: -100, msg: "参数信息有误" }
      }
      var orderInfo = await this.dao.findItemByOrderNo(orderNo);
      if (!orderInfo) {
        return { code: -110, msg: "订单信息有误" }
      }
      if (orderInfo.orderPayStatus == "yfk") {
        return { code: 1, msg: "ok", data: { orderPayStatus: "yfk" } };
      }
      var payTrxid = opType == "wx" ? wxPayOrderCode : aliPayOrderCode;
      var payStatus = await this.utilstlbankSve.queryOrder(comanyId, payTrxid);
      logCtl.info({
        optitle: "查询其他支付状态---info",
        op: "/base/service/impl/orderSve.js/checkPayStatusTl",
        content: "返回结果=" + JSON.stringify(payStatus),
        clientIp: obj.client_ip || ""
      });
      if (payStatus && payStatus.code == 1 && payStatus.data.trxstatus == "0000") {
        payStatus.data.client_ip = obj.client_ip || "";
        let attachList = [];
        if (payStatus.data.reqsn.indexOf("_") >= 0) {
          attachList = payStatus.data.reqsn.split("_");
        }
        else {
          attachList.push(payStatus.data.reqsn);
        }
        if (attachList.length < 2) {
          return { code: -120, msg: "reqsn参数错误，没有_标识" };
        }
        //解析支付参数
        payStatus.data.out_trade_no = attachList[0];
        payStatus.data.company_id = attachList.length == 2 ? attachList[1] : attachList[2];
        payStatus.data.other_company_id = attachList.length == 2 ? "0" : attachList[1];

        //操作回调
        if (payStatus.data.other_company_id && Number(payStatus.data.other_company_id) > 0) {
          var otherPayParam = await this.companypayparamDao.getOneByCompanyId(payStatus.data.other_company_id, 1);
          if (!otherPayParam) {
            return { code: -140, msg: "回调其他公司公司没有对应的配置信息" };
          }
          return await this.utilstlbankSve.opOtherCompanyNotify(otherPayParam.notifyUrl, payStatus.data, "通联回调");
        }//是别的公司则进行回调别的接口信息
      }
      else if (payStatus && payStatus.code == 1 && payStatus.data.trxstatus == "3045") {
        return { code: -330, msg: "超时未支付，请刷新页面" };
      }
      return { code: -130, msg: "请及时支付" };
    } catch (e) {
      logCtl.error({
        optitle: "支付页面回调支付状态---error异常",
        op: "/base/service/impl/orderSve.js/checkPayStatus",
        content: "error：" + e.stack + "，参数=" + JSON.stringify(obj),
        clientIp: obj.client_ip || ""
      });
      return { code: -200, msg: "接口异常" };
    }
  }
}
module.exports = TlOrderService;
