const system = require("../../system");
const ServiceBase = require("../sve.base")
const settings = require("../../../config/settings")
class MoneyAccountService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(MoneyAccountService));
    this.companyDao = system.getObject("db.companyDao");
  }
  async fetchAccountForBoss(companyid) {//公司账户列表余额展示-------============XXXX
    var result = await this.db.query('SELECT name,sum(balance) as value FROM `biz_moneyaccount` WHERE company_id =:status group by name ',
      { replacements: { status: companyid }, type: this.db.QueryTypes.SELECT });
    console.log(result);
    return result;
  }
  async findAllByCompanyId(company_id) {//查询公司供转账的账户
    var self = this;
    return this.dao.model.findAll({
      where: { company_id: company_id, accountType: "bank", isPlatformAutopay: 1 },
      attributes: ["id", "code", "name", "certificateNo", "payeeName"],
      include: [
        {
          model: self.companyDao.db.models.company,
          attributes: ["id", "code", "name"]
        }
      ]
    });
  }
}
module.exports = MoneyAccountService;
