const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/codenamebase")(db, DataTypes);
  return db.define("tmstuff", Object.assign({//商标材料：
    // 引用表的信息:
    // //商标官文引用用户表
    // this.db.models.tmstuff.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });


    //基类 code: 来源单号--订单号
    //基类 name:  附件名称
    //商标类型形式："1": "立体", "3": "字", "4": "图", "5": "字图", "6": "颜色", "7": "彩色"


    stuffTypeName: DataTypes.STRING,
    stuffType: {
      //附件类型:"csty": "彩色图样", "wts": "委托书", "gzwts": "盖章委托书", "ty": "图样" , "sywj": "声音文件" , "smwj": "说明文件"
      //注：彩色商标图样：商标类型形式为7则有此值
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.stuff_type),
      set: function (val) {
        this.setDataValue("stuffType", val);
        this.setDataValue("stuffTypeName", uiconfig.config.pdict.stuff_type[val]);
      }
    },
    stuffUrl: DataTypes.STRING(500),//附件地址
    notes: DataTypes.STRING,//备注      
  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_tmstuff',
      validate: {
      }
    });
}
