const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  var base = require("../basemodel/voucherbase")(db, DataTypes);
  return db.define("order", Object.assign({
    // 引用表的信息:
    // //订单表引用用户信息
    // this.db.models.order.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });
    // this.db.models.order.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
    // this.db.models.order.belongsTo(this.db.models.user, { as: 'audituser', constraints: false, });

    // //订单
    // this.db.models.order.belongsTo(this.db.models.receiptvoucher, { constraints: false, });//支付信息
    // this.db.models.order.belongsTo(this.db.models.invoiceapply, { constraints: false, });//发票信息

    //基类 code: 订单号（自动生成）
    //基类 name: ---用于商标名称-------del、
    //基类 creator: 创建者
    //基类 updator:/更新者
    //基类 auditor: 审核者
    //基类 opNotes: 操作备注
    //基类 auditStatusName: //审核状态名称
    //基类 auditStatus: //审核状态:ENUM=audit_status，"dsh": "待审核", "btg": "不通过", "tg": "通过"
    //基类 sourceTypeName: //来源类型名称
    //基类 sourceType: //来源类型:ENUM=source_type，"order": "订单","expensevoucher": "费用单","receiptvoucher": "收款单", "trademark": "商标单"
    //基类 sourceOrderNo: DataTypes.STRING,//来源单号 
    accountType: {
      //帐户类型（ 支付类型）:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.accountType),
      set: function (val) {
        this.setDataValue("accountType", val);
        this.setDataValue("accountTypeName", uiconfig.config.pdict.accountType[val]);
      }
    },
    accountTypeName: {//帐户类型名称
      type: DataTypes.STRING,
    },
    wxPayOrderCode: DataTypes.STRING(50),//业务微信支付订单号
    aliPayOrderCode: DataTypes.STRING(50),//业务支付宝支付订单号
    busPayOrderCode: DataTypes.STRING(50),//业务支付订单号
    invoiceApplyStatusName: {//发票状态名称
      type: DataTypes.STRING(50),
      defaultValue: "未申请",
    },
    invoiceApplyStatus: {//发票状态:"1": "未申请", "2": "已申请","3":"已开票"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.invoice_apply_status),
      defaultValue: "1",
      set: function (val) {
        this.setDataValue("invoiceApplyStatus", val);
        this.setDataValue("invoiceApplyStatusName", uiconfig.config.pdict.invoice_apply_status[val]);
      }
    },
    isIinvoice: {//是否需要发票，0不需要，1需要，默认为1
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    orderTypeName: DataTypes.STRING(50),
    orderType: {//订单类型，"zzdd": "自主订单","dkxd": "代客下单" 
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_type),
      set: function (val) {
        this.setDataValue("orderType", val);
        this.setDataValue("orderTypeName", uiconfig.config.pdict.order_type[val]);
      }
    },
    salesNum: {//项目订单数量（即服务项目的倍数，默认值为1）
      type: DataTypes.INTEGER,
      defaultValue: 1
    },
    salesDiliverNum: {//项目订单交付数量（即与项目订单数量相对应）
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    orderPayStatusName: {//订单付款状态名称
      type: DataTypes.STRING(50),
      defaultValue: "待付款",
    },
    orderPayStatus: {//订单付款状态"dfk": "待付款", "zfpz": "已上传支付凭证", "yfk": "已付款", "ddqx": "订单取消", "tkclz": "退款处理中", "ytk": "已退款"//---加支付审核不通过
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_pay_status),
      defaultValue: "dfk",
      set: function (val) {
        this.setDataValue("orderPayStatus", val);
        this.setDataValue("orderPayStatusName", uiconfig.config.pdict.order_pay_status[val]);
      }
    },

    notes: DataTypes.STRING,//备注    
    orderSourceName: {//订单来源名称
      type: DataTypes.STRING(50),
      defaultValue: "公司案源",
    },
    orderSource: {//订单来源"gsay": "公司案源", "ptsj": "平台商机", "wzzx": "网站咨询"
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_source),
      defaultValue: "gsay",
      set: function (val) {
        this.setDataValue("orderSource", val);
        this.setDataValue("orderSourceName", uiconfig.config.pdict.order_source[val]);
      }
    },
    pfSettleProfit: {//平台结算渠道利润,0否，1是
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    //订单所有计算都是含税-------------------------------------------------------------------------
    totalServiceCharge: DataTypes.DECIMAL(12, 2),//服务费总额（产品配置的服务费*订单件数）
    totalPublicExpense: DataTypes.DECIMAL(12, 2),//官费总额（产品配置的官费*订单件数）
    totalDiscounts: DataTypes.DECIMAL(12, 2),//优惠总额（（服务费总额+官费总额）-订单总额(产品价格×优惠费率×订单件数)>0则有优惠额度）
    totalTaxes: DataTypes.DECIMAL(12, 2),//税费总额（订单总额-(订单总额/（1+产品费率）)）
    totalSum: DataTypes.DECIMAL(12, 2),//订单总额(产品价格×优惠费率×订单件数)
    totalProfitSum: DataTypes.DECIMAL(12, 2),//订单毛利润总额（订单总额-官费总额）
    pfProfitSum: DataTypes.DECIMAL(12, 2),//订单平台毛利润总额（订单毛利润总额-订单渠道分成毛利润总额）
    channelProfitSum: DataTypes.DECIMAL(12, 2),//订单渠道分成毛利润总额(（订单总额-官费总额）*渠道利润分成比率)
    //客户联系人
    contacts: DataTypes.STRING(20),//联系人
    mobile: DataTypes.STRING(20),//手机号
    email: DataTypes.STRING(50),//邮箱
    tel: DataTypes.STRING(20),//座机
    fax: DataTypes.STRING(50),//传真
    zipCode: DataTypes.STRING(20),//邮政编码  
    // productonetype_id: DataTypes.INTEGER,//产品大类Id----add
    payTime: DataTypes.DATE,//支付时间

    //---------------------------new table----------------------------
    sveItemCode: DataTypes.STRING(100),//项目操作码
    sveItemName: DataTypes.STRING(100),//项目名称
    mobilePic: DataTypes.STRING,//移动端产品图片
    productonetype_id: DataTypes.INTEGER,//产品大类Id-----------------------------------del
    producttype_id: DataTypes.INTEGER,//产品小类Id 
    serviceItemSnapshot: DataTypes.TEXT,//产品快照-serviceitem服务项目表-JSON
    channelProfitRate: {//渠道利润分成比率(只分订单中毛利润总额的分成)
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 0,
    },
    sveItemRateConfig: {//产品费率
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 7.00,
    },
    sveDiscountsRateConfig: {//优惠税率
      type: DataTypes.DECIMAL(12, 2),
      defaultValue: 0,
    },
    // this.db.models.order.belongsTo(this.db.models.customerinfo, { constraints: false, });//申请人表（企业或个人）
    orderFlowStatusName: DataTypes.STRING(50),
    orderFlowStatus: {//订单流程状态"1": "提交订单", "2": "已付款", "3": "已审核-待递交", "4": "已递交", "5": "已完成" ----del
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_flow_status),
      set: function (val) {
        this.setDataValue("orderFlowStatus", val);
        this.setDataValue("orderFlowStatusName", uiconfig.config.pdict.order_flow_status[val]);
      }
    },
    orderStatusName: DataTypes.STRING(50),
    orderStatus: {//订单状态"1": "提交订单", "2": "待上传材料", "3": "待审核", "4": "审核不通过", "5": "待递交" , "6": "部分递交异常", "7": "已完成"  ---del 
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.order_status),
      set: function (val) {
        this.setDataValue("orderStatus", val);
        this.setDataValue("orderStatusName", uiconfig.config.pdict.order_status[val]);
      }
    },
    nclOneCodesNum: DataTypes.INTEGER,//大类件数  
    orderAppendinfo: DataTypes.STRING(4000),//订单附加信息

    nclOneCodes: DataTypes.INTEGER,//尼斯大类---暂时没有用到
    subType: {//提报类型:"platform": "平台", "self": "自己"
      type: DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.sub_type),
      defaultValue: "platform",
    },
    //支付状态：待支付，已支付---（用于提供交付数据、待材料审核的数据）
    //新增商标交付状态------// "2": "待上传材料", "3": "待审核", "4": "审核不通过", "5": "待递交" , "6": "部分递交异常", "7": "已完成"  

    //---------------------------del-----------------------------------------------------
    sveItemType: DataTypes.STRING(100),
    //  {//--------del暂时没有用到
    //   //服务项目类型:"ip": "商标", "ic": "版权", "pa": "专利", "iso": "海外业务", "common": "增值服务", "icbc": "工商注册",
    //   //"zscq": "知识产权", "cwfw": "财务服务", "hyzz": "行业资质", "gqzr": "股权转让", "xzsp": "行政审批"
    //   type: DataTypes.ENUM,
    //   allowNull: false,
    //   values: Object.keys(uiconfig.config.pdict.productCata),
    //   defaultValue: "ip",      
    // },


  }, base), {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'biz_order',
      validate: {
      }
    });
}
