const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("businesscompany", {
    // 引用表的信息:
    // this.db.models.businesscompany.belongsTo(this.db.models.company, { constraints: false, });//来源，默认1即平台
    // this.db.models.businesscompany.belongsTo(this.db.models.company, { as: 'createcompany', constraints: false, });//认领人公司
    // this.db.models.businesscompany.belongsTo(this.db.models.user, { as: 'createuser', constraints: false, });//认领人
    // this.db.models.businesscompany.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });

    code: DataTypes.STRING(50),//唯一码
    applicant_cn: DataTypes.STRING(1000),//申请人中文
    applicant_en: DataTypes.STRING(1000),//申请人英文
    applicant_cn_addr: DataTypes.STRING(500),//申请人中文地址
    applicant_en_addr: DataTypes.STRING(1000),//申请人英文地址
    tm_end_day_min: DataTypes.DATE,//商标截至时间（续展时间）最小，格式2019-03-01
    tm_end_day_max: DataTypes.DATE,//商标截至时间（续展时间）最大，格式2019-03-01
    reg_property: DataTypes.STRING(255),//企业性质
    reg_capital: DataTypes.STRING(50),//注册资本
    company_mail: DataTypes.STRING(2000),//公司邮箱
    sve_item_code: DataTypes.STRING(50),//项目操作码
    sve_item_name: DataTypes.STRING(100),//项目名称    
    tm_company_type_name: DataTypes.STRING(50),//商机类型名称
    tm_company_type: {//商机类型：xz: 商标续展，kz：商标宽展，bh: 商标驳回复审，bysl: 商标不予受理，yy: 商标异议，bg: 商标变更
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.tm_company_type),
      set: function (val) {
        this.setDataValue("tm_company_type", val);
        this.setDataValue("tm_company_type_name", uiconfig.config.pdict.tm_company_type[val]);
      }
    },
    total_amount: DataTypes.INTEGER,//商机总数
    total_worth: DataTypes.INTEGER,//商机价值
    business_status_name: DataTypes.STRING(50),//商机状态名称
    business_status: {//商机状态：wrl未认领、yrl已认领、bhz保护中、wx无效
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.business_status),
      set: function (val) {
        this.setDataValue("business_status", val);
        this.setDataValue("business_status_name", uiconfig.config.pdict.business_status[val]);
      }
    },
    customer_intention_name: DataTypes.STRING(50),//客户意向名称
    customer_intention: {//客户意向：yxyb: 意向一般, yxhg: 重要意向, wjt: 未接通
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.customer_intention),
      set: function (val) {
        this.setDataValue("customer_intention", val);
        this.setDataValue("customer_intention_name", uiconfig.config.pdict.customer_intention[val]);
      }
    },    
    claim_time: DataTypes.DATE,//认领时间
    recovery_time: DataTypes.DATE,//收回截止时间
    indicative_price: {//指导价格
      type: DataTypes.STRING(50),
      defaultValue: "¥1399(官费:500)",
    },
    invalid_num: {//商机无效数量--存储业务员打商标无效标记的次数
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    order_num: {//下订单数量--存储业务员下单的次数
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },    
    check_mobile: {//验证手机是否有效
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    mobile_invalid_num: {//手机无效次数
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    bus_invalid_num: {//业务无效次数
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    mobile_list: DataTypes.STRING(4000),//手机号列表，格式：["15010929366","15010929388"]
    notes: DataTypes.STRING,//备注
    op_notes: DataTypes.STRING(50),//操作备注   
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      //freezeTableName: true,
      // define the table's name
      tableName: 'bi_businesscompany',
      validate: {

      },
      indexes: [
      ]
    });
}
