const system=require("../../system");
const Dao=require("../dao.base");
class ServiceitemDao extends Dao{
  constructor(){
    super(Dao.getModelName(ServiceitemDao));
    this.producttypeDao = system.getObject("db.producttypeDao");
  }
  extraModelFilter(){
    return {"key":"include","value":[{model:this.db.models.producttype,attributes:["id","name"]},]};
  }
  async findOneByCode(code,cid){
    return this.model.findOne({"where":{"code":code,"company_id":cid}});
  }
  orderBy() {
    //return {"key":"include","value":{model:this.db.models.app}};
    return [["sort", "ASC"]];
  }
  async create(u, t) {
    if(u.producttype_pid_id){
      var pt= await this.producttypeDao.model.findOne({where:{id:u.producttype_pid_id},raw:true});
      if(pt){
        u["itemType"]= pt.code;
        u["itemTypeName"] = pt.name;
      }
    }
    if (t) {
      return this.model.create(u, { transaction: t }).then(u => {
        return u;
      });
    } else {
      return this.model.create(u).then(u => {
        return u;
      });
    }
  }
}
module.exports=ServiceitemDao;
