var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl=system.getObject("web.oplogCtl");
class CustomerInfoCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(CustomerInfoCtl));
   }
   async findOneByCustomerName(obj,req){
     if(!obj.name){
       return {code:-1,msg:"name参数错误"};
     }
     try {
       var data = await this.service.dao.model.findOne({where:{name:obj.name}});
       return {code:1,data:data};
     } catch (error) {
      return {code:-100,msg:"操作失败"};
     }
   }
   async getMyCustomerEntInfo(obj,req){
    var user = req.session.user;
    if(user){
      try {
      var result=[];
        var dataList = await this.service.dao.model.findAll({where:{owner_id:user.id,customerType:"ent"},limit:50,offset:0,attributes: ["applyAddr", "code", "name", "businessLicensePic", "customerType","identityCardNo","identityCardPic"],raw:true});
        if(dataList && dataList.length>0){
          for(var i=0;i<dataList.length;i++){
            var data = dataList[i];
            var obj={regLocation:data.applyAddr,entName:data.name,domainEntName:data.name,creditCode:data.code,
              businessLicensePic:data.businessLicensePic,customerType:data.customerType,identityCardNo:data.identityCardNo,
              identityCardPic:data.identityCardPic
            };
            result.push(obj);
          }
        }
        return {code:1,data:result};
      } catch (error) {
       return {code:-100,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
    
  }
  async getMyCustomerPersonInfo(obj,req){
    var user = req.session.user;
    var likename = obj.likeName;
    if(user){
      try {
        var result=[];
        var whereObj={owner_id:user.id,customerType:"person"};
        //,name: { [this.dao.db.Op.like]: '%' +mobile_no + '%' }
        if(likename){
          whereObj["name"] = { [this.service.dao.db.Op.like]: '%' +likename + '%' };
        }
        var dataList = await this.service.dao.model.findAll({where:whereObj,limit:50,offset:0,attributes: ["applyAddr", "code", "name", "businessLicensePic", "customerType","identityCardNo","identityCardPic"],raw:true});
        if(dataList && dataList.length>0){
          for(var i=0;i<dataList.length;i++){
            var data = dataList[i];
            var obj={regLocation:data.applyAddr,entName:data.name,domainEntName:data.name,creditCode:data.code,
              businessLicensePic:data.businessLicensePic,customerType:data.customerType,identityCardNo:data.identityCardNo,
              identityCardPic:data.identityCardPic
            };
            result.push(obj);
          }
        }
        return {code:1,data:result};
      } catch (error) {
       return {code:-100,msg:"操作失败"};
      }
    }else{
      return {code:-200,msg:"用户数据为空"};
    }
    
  }
}
module.exports=CustomerInfoCtl ;
