var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
const {json} = require("sequelize");
const {getResult, getResultSuccess} = require("../../../system");

//需求操作类----操作类型-公用的--未用到
class UtilsNeedCommService extends AppServiceBase {
    constructor() {
        super();
        this.centerOrderUrl = settings.centerOrderUrl();
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.aliclient = system.getObject("util.aliyunClient");
        this.ossClient = system.getObject("util.ossClient");
        this.restClient = system.getObject("util.restClient");
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
        this.opPushQueueUrl = settings.opPushQueueUrl();
        this.utilsAuthSve = system.getObject("service.utilsSve.utilsAuthSve");
    }

    /**
     * 提交需求
     * @param {*} pobj
     * @param {*} actionBody
     */
    async submitNeed(pobj, actionBody) {
        if (actionBody.type == "esp.wangwen" || actionBody.type == "esp.food") {
            actionBody.area = this.wangwenAreaChange(actionBody.area)
        }
        if (!actionBody.type && actionBody.consultType)
            actionBody.type = actionBody.consultType
        if (!actionBody.intentionBizId) {
            return system.getResult(null, "actionBody.intentionBizId can not be empty，100380");
        }
        var sobj = pobj;
        sobj.actionType = "getProductTypeInfo";
        var url = settings.centerAppUrl() + "action/opProduct/springBoard";
        var rtn = await this.execClient.execPost(sobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResultFail(-5015, "需求类型查询失败");
        }
        var data = JSON.parse(rtn.stdout);
        if (data.status != 0) {
            return system.getResultFail(-5015, "需求类型查询失败");
        }
        pobj.actionBody.service_product_id = data.data.service_product_id;
        pobj.actionBody.productId = data.data.service_product_id;
        pobj.actionBody.appName = pobj.appInfo.app_name;
        pobj.actionBody.type_code = data.data.type_code;
        pobj.actionBody.type_name = data.data.type_name;
        pobj.actionBody.channel_type_code = data.data.channel_type_code;
        pobj.actionBody.channel_type_name = data.data.channel_type_name;
        pobj.actionBody.type = pobj.actionBody.channel_type_code;
        pobj.actionBody.phone = pobj.actionBody.phone || pobj.actionBody.mobile;
        pobj.actionBody.idempotentId = pobj.actionBody.intentionBizId;
        pobj.actionBody.idempotentSourceName = pobj.appInfo.app_name;
        pobj.actionType = "submitNeed";
        var reqUrl = this.centerOrderUrl + "action/need/springBoard";
        var result = await this.restPostUrl(pobj, reqUrl);
        if (result.status == 0) {
            //做推送信息
        }
        return result;
    }

}

module.exports = UtilsNeedCommService;
