const system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const crypto = require('crypto');
const cryptoJS = require("crypto-js");

class ToolService extends AppServiceBase {
  constructor() {
    super();
    this.zcApiUrl = settings.reqZcApi();
    // this.execClient = system.getObject("util.execClient");
  }
  async getCropperPic(obj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCropperPic";
    return await this.opReqResult(url, obj, req);
  }
  //智能分析 bycquerytm.html
  async bycznfx(obj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/bycznfx";
    return await this.opReqResult(url, queryobj, req);
  }
  //根据尼斯编号获取尼斯子类，尼斯树节点点击时触发调用
  async getNcl(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getNcl";
    return await this.opReqResult(url, queryobj, req);
  }
  //根据大类、名称查询尼斯信息
  async getNclByLikeNameAndNcl(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getNclByLikeNameAndNcl";
    return await this.opReqResult(url, queryobj, req);
  }
  //文字转图片
  async word2pic(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/word2pic";
    return await this.opReqResult(url, queryobj, req);
  }
  //商标样式转换 彩色商标图样转黑白，调整图样宽高，生成符合商标局规范的标准商标图样
  async uploadStandardTm(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/uploadStandardTm";
    return await this.opReqResult(url, queryobj, req);
  }
  //营业执照（身份证明）图片文件转为符合商标局要求的pdf文件
  async pic2pdf(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/pic2pdf";
    return await this.opReqResult(url, queryobj, req);
  }
  //企业近似查询
  async getCompanyInfoByLikeName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getCompanyInfoByLikeName";
    var result = await this.opReqResult(url, queryobj, req);
    if (result.data.length > 0) {
      return system.getResultSuccess(result.data);
    }
    return system.getResult(null, "data is empty，100565");
  }
  //企业注册信息精确查询
  async getEntregistryByCompanyName(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getEntregistryByCompanyName";
    var result = await this.opReqResult(url, queryobj, req);
    if (Object.keys(result).length > 3) {
      return system.getResultSuccess(result);
    }
    return system.getResult(null, "data is empty，100560");
  }
  //调整委托书 调整委托书大小使其符合商标局规范
  async adjustWTSSize(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/adjustWTSSize";
    return await this.opReqResult(url, queryobj, req);
  }
  //工商核名
  async icheming(queryobj, req) {
    let url = settings.icNameUrl() + 'ic/match';
    let obj = {
      cityname: queryobj.cityname, //注册城市地区
      keyword: queryobj.keyword, //公司字号
      btname: queryobj.btname, //行业类型
      orgname: queryobj.orgname, //组织类型
      appkey: "5b29981785bd4272966b15ad8e8b9dd3"
    };
    let result = await this.restPostUrl(obj, url);
    return system.getResultSuccess(result);
  }
  //尼斯过滤
  async getTmNclFilterSearch(queryobj, req) {
    var url = this.zcApiUrl + "api/tool/toolApi/getTmNclFilterSearch";
    return await this.opReqResult(url, queryobj, req);
  }
  async opReqResult(reqUrl, queryobj, req) {
    var rtn = await this.execClient.execPushDataPost(queryobj, reqUrl, req.headers["token"] || null, req.headers["request-id"]);
    var data = JSON.parse(rtn.stdout);
    return data;
  }

  async getOssConfig(pobj, req) {//获取oss信息
    var reqUrl = settings.reqZcApi() + "api/tool/toolApi/getOssConfig";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }
  //加密信息
  async encryptStr(app, opStr) {
    if (!opStr) {
      return system.getResult(null, "opStr is empty");
    }
    let keyHex = cryptoJS.enc.Utf8.parse(app.uappKey);
    let ivHex = cryptoJS.enc.Utf8.parse(app.appSecret.substring(0, 8));
    var cipherStr = cryptoJS.TripleDES.encrypt(opStr, keyHex, { iv: ivHex }).toString();
    return system.getResultSuccess(cipherStr);
  }
  //解密信息
  async decryptStr(app, opStr) {
    if (!opStr) {
      return system.getResult(null, "opStr is empty");
    }
    let keyHex = cryptoJS.enc.Utf8.parse(app.uappKey);
    let ivHex = cryptoJS.enc.Utf8.parse(app.appSecret.substring(0, 8));
    var bytes = cryptoJS.TripleDES.decrypt(opStr, keyHex, {
      iv: ivHex
    });
    var plaintext = bytes.toString(cryptoJS.enc.Utf8);
    return system.getResultSuccess(plaintext);
  }

  //智能推荐
  async getNclByCode(pobj,req){
    var reqUrl = settings.centerOrderUrl() + "action/tmOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }

  //智能推荐
  async getAllNcl(pobj,req){
    var reqUrl = settings.centerOrderUrl() + "action/tmOrder/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    return result;
  }


}
module.exports = ToolService;

