const System = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
class FblicenseService extends AppServiceBase {
  constructor () {
    super();
    this.fbqurl = settings.fbQueryUrl()
    this.restClient = System.getObject("util.restClient")
  };

  // 精确查找 (首页)
  async exactSearch (id) {
    try {
      if (!(id)) {
        return {
          code: 0,
          msg: "success",
          data: [],
          count: 0,
          page: 1,
          pagesize: 10
        }
      }
      let param = { name: id }
      let url = `${this.fbqurl}/gsb/licence_search_index`
      let result = await this.restClient.execPost(param, url)
      result = JSON.parse(result.stdout)
      result.count = result.total
      delete result.total
      result.code = result.status == -1 ? -1 : 0
      delete result.status
      if (result.data) {
        result.data = this.dealForList(result.data)
      }
      return result
    } catch (error) {
      return {
        code: -1,
        msg: error.message || 'failed',
      }
    }
  }


  // 获取详情
  async getDetail (id) {
    try {
      if (!id) {
        return {
          "msg": "success",
          "code": 0,
          "data": null
        }
      }
      let param = { id }
      let url = `${this.fbqurl}/gsb/licence_search_detail`
      let result = await this.restClient.execPost(param, url)
      result = JSON.parse(result.stdout)
      return {
        code: result.status == -1 ? -1 : 0,
        msg: result.msg,
        data: result.data[0]
      }
    } catch (error) {
      return {
        code: -1,
        msg: error.message || 'failed',
      }
    }
  }

  // 获取列表
  async getList (data) {
    if (!(data.company_name || data.license_no)) {
      return {
        code: 0,
        msg: "success",
        data: [],
        count: 0,
        page: 1,
        pagesize: 10
      }
    }
    try {
      let param = {
        operator_name: data.company_name || "",
        licence_number: data.license_no || "",
        region: data.base || "",
        pub_year: data.pub_year || "",
        subject_format: data.subject_format || "",
        status: data.status || "",
        page: data.page || 1,
        pagesize: data.pageSize || 10,
        sort: data.sort ? { [`${data.sort.split(" ")[0]}`]: { order: data.sort.split(' ')[1] } } : ""
      }
      let url = `${this.fbqurl}/gsb/licence_search_condition`
      let result = await this.restClient.execPost(param, url)
      result = JSON.parse(result.stdout)
      result.count = result.total
      delete result.total
      result.code = result.status == -1 ? -1 : 0
      delete result.status
      if (result.data) {
        result.data = this.dealForList(result.data)
      }
      return result
    } catch (error) {
      return {
        code: -1,
        msg: error.message || 'failed',
      }
    }
  }

  // 组织列表数据
  dealForList (data) {
    return data.map(val => {
      return {
        id: val.id,
        license_no: val.license_no,
        company_name: val.company_name,
        pub_date: val.pub_date,
        end_date: val.end_date
      }
    })
  }
}
module.exports = FblicenseService;
