var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const axios = require("axios");
const { getResult } = require("../../../system");

class Zzzd extends WEBBase {
    constructor () {
        super();
        this.restClient = system.getObject("util.restClient");
        this.redisClient = system.getObject("util.redisClient");
        this.zzzApi = {
            "industryOne": "/gsb/api/industry_one",  //一级大类列表
            "industryTwo": "/gsb/api/industry_two",  //二级大类列表
            "getQualificationByIndustry": "/gsb/api/qualifications",  //根据行业ID 查询所有相关的资质
            "recommendationBusiness": "/gsb/api/recommendation_business",  //立即查看结果
            "phoneNumber": "/gsb/api/phone_number",  //免费咨询
        }
        this.utilsDiagnosisSve = system.getObject("service.utilsSve.utilsDiagnosisSve");
        this.centerOrderUrl = settings.centerOrderUrl();
    }
    /**
     * 接口跳转-POST请求
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springBoard (pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    
    checkFilter(arr) {
        if(!arr) {
            return [];
        }
        return arr.filter((obj) => {
            obj.picUrl = "";
            obj.picName = obj.name;
            delete obj.id;
            delete obj.name;
            return obj
        });
    }

    async opActionProcess (pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "getIndustries":  //获取一级大类列表
                try {
                    console.log(`获取一级大类列表 参数：` + JSON.stringify(pobj.actionBody));
                    if (!pobj.actionBody.platformCode) {
                        return system.getResult(null, `平台ID不能为空`)
                    }
                    // 2020 0807 林 修改 rediskey 增加platformCode 平台ID必填参数
                    let _industryOne = await this.redisClient.get("industryOne" + pobj.actionBody.platformCode);
                    if (_industryOne) {
                        opResult = system.getResult(JSON.parse(_industryOne));
                        console.log("redis数据：" + _industryOne);
                    } else {
                        opResult = await this.restPostUrl(pobj.actionBody, settings.zzzdUrl() + this.zzzApi.industryOne);
                        await this.redisClient.setWithEx("industryOne", JSON.stringify(opResult.data), 45 * 60);
                        console.log(`获取一级大类列表 结果` + JSON.stringify(opResult));
                    }
                } catch (e) {
                    console.log(e);
                    return system.getResult(null, `系统错误`);
                }
                break;
            case "getSecondIndustries":  //获取二级大类列表
                console.log(`获取二级大类列表 参数：` + JSON.stringify(pobj.actionBody));
                if (!pobj.actionBody.industryId) {
                    return system.getResult(null, `一级行业ID不能为空`)
                }
                if (!pobj.actionBody.platformCode) {
                    return system.getResult(null, `平台ID不能为空`)
                }
                try {
                    // await this.redisClient.delete(`industryTwo:${pobj.actionBody.industryId}`);
                    let _industryTwo = await this.redisClient.get(`industryTwo:${pobj.actionBody.industryId}` + pobj.actionBody.platformCode);
                    if (_industryTwo) {
                        opResult = system.getResult(JSON.parse(_industryTwo));
                        console.log("redis数据：" + _industryTwo);
                    } else {
                        opResult = await this.restPostUrl(pobj.actionBody, settings.zzzdUrl() + this.zzzApi.industryTwo);
                        await this.redisClient.setWithEx(`industryTwo:${pobj.actionBody.industryId}`, JSON.stringify(opResult.data), 45 * 60);
                        console.log(`获取二级大类列表 结果` + JSON.stringify(opResult));
                    }
                } catch (e) {
                    console.log(e);
                    return system.getResult(null, `系统错误`);
                }
                break;
            case "getQualificationByIndustry":  //根据行业获取资质
                try {
                    console.log(`根据行业获取资质 参数：` + JSON.stringify(pobj.actionBody));
                    if (!pobj.actionBody.hasOwnProperty("isImports")) {
                        return system.getResult(null, `参数错误 是否进口不能为空`)
                    }
                    if (!pobj.actionBody.hasOwnProperty("storeTypeId") && !pobj.actionBody.storeTypeId) {
                        return system.getResult(null, `参数错误 店铺类型ID不能为空`)
                    }
                    if (!pobj.actionBody.industryId) {
                        return system.getResult(null, `一级行业ID不能为空`)
                    }
                    if (!pobj.actionBody.secondIndustry && pobj.actionBody.secondIndustry.length > 0) {
                        return system.getResult(null, `二级行业不能为空`)
                    }
                    opResult = await this.restPostUrl(pobj.actionBody, settings.zzzdUrl() + this.zzzApi.getQualificationByIndustry);
                    console.log(`根据行业获取资质 结果` + JSON.stringify(opResult));
                } catch (e) {
                    console.log(e);
                    return system.getResult(null, `系统错误`);
                }
                break;
            case "check":  //立即查看结果
                if (!pobj.actionBody.industryId) {
                    return system.getResult(null, `行业ID不能为空`)
                }
                if (!pobj.actionBody.mobile) {
                    return system.getResult(null, `电话不能为空`);
                }
                if (!pobj.actionBody.enterprise) {
                    return system.getResult(null, `企业名称不能为空`);
                }
                if (!pobj.actionBody.data) {
                    return system.getResult(null, `资质列表不能为空`);
                }
                try {
                    opResult =await this.restPostUrl(pobj.actionBody,settings.zzzdUrl()+this.zzzApi.recommendationBusiness);
                    // 调用order创建诊断单方法，并把大数据诊断结果传过去，以及客户选择的行业分类带过去 格式 【一级分类-二级分类，】
                    pobj.actionBody.checkResult = opResult;
                    pobj.actionBody.qualificationsPic = this.checkFilter(pobj.actionBody.data.base);// 记录智能诊断的资质信息
                    pobj.actionBody.brandPic = this.checkFilter(pobj.actionBody.data.brand);
                    pobj.actionBody.industryPic = this.checkFilter(pobj.actionBody.data.industry);
                    pobj.actionBody.diagnosisMode = "zn";
                    pobj.actionType = "manualEvaluation"
                    var reqUrl = this.centerOrderUrl + "action/diagnosis/springBoard";
                    let res = await this.restPostUrl(pobj,reqUrl);
                    if(res.status == 0) {
                        opResult.data.diagnosis_no = res.data.diagnosis_no
                    }
                    console.log(res);
                }catch (e) {
                    console.log(e);
                    return system.getResult(null, `系统错误` + JSON.stringify(e));
                }
                break;
            case "counselling":  //免费咨询
                if (!pobj.actionBody.id) {
                    return system.getResult(null, `业务ID不能为空`)
                }
                if (!pobj.actionBody.mobile) {
                    return system.getResult(null, `电话不能为空`);
                }
                pobj.actionBody.enterprise = pobj.actionBody.enterprise ? pobj.actionBody.enterprise : "";
                try {
                    console.log("免费参数" + JSON.stringify(pobj));
                    opResult = await this.restPostUrl(pobj.actionBody, settings.zzzdUrl() + this.zzzApi.phoneNumber);
                    console.log(`根据行业获取资质 结果` + JSON.stringify(opResult));
                } catch (e) {
                    console.log(e);
                    return system.getResult(null, `系统错误`);
                }
                break;
            case "uploadBusiness":
                if (!pobj.actionBody.picUrl) {
                    return system.getResult(null, `-zzzd03 图片地址不能为空`);
                }
                if (!pobj.actionBody.identityCardNo) {
                    return system.getResult(null, `-zzzd04 身份证号不能为空`);
                }
                var reqParam = {
                    bl_url: pobj.actionBody.picUrl
                }
                // 分析营业执照
                var result = await this.restPostUrl(reqParam, settings.businessDistinguishUrl() + "gsb/businessLicenseUrlApi");
                if (result.status != 1) {
                    return getResult(null, "-zzzd01" + result.msg)
                }
                // 判断 如果四要素有空 则 不请求 并返回营业执照解析失败
                if (result.data.legal_person == "无") {
                    return system.getResult(null, "-zzzd06 审核不通过，原因:营业执照法人名字分析失败");
                }
                // 这里写死判断，如果等于测试的营业执照 不走判断地址 因为测试营业执照分析不出地址
                // https://gsb-zc.oss-cn-beijing.aliyuncs.com//zc_958415948076283422020615.jpg
                if (result.data.credit_code == "92410204MA47NYPD41") {
                    result.data.company_name = "开封市鼓楼区任我行科技技术服务部"
                } else {
                    if (result.data.company_name == "无") {
                        return system.getResult(null, "-zzzd05 审核不通过，原因:营业执照组织机构名称分析失败");
                    }
                }
                if (result.data.credit_code == "无" && result.data.reg_number == "无") {
                    return system.getResult(null, "-zzzd07 审核不通过，原因:营业执照社会信用代码或注册号分析失败");
                }
                // 请求四要素验证
                var fourFactorsReqParam = {
                    channel: 1,// 写死1 代表上游渠道号 e签宝的
                    legalRepIdNo: pobj.actionBody.identityCardNo, // 法人身份证号
                    legalRepName: result.data.legal_person, // 法人名字
                    name: result.data.company_name, // 组织机构证件（如营业执照）上的组织机构名称
                    orgCode: result.data.credit_code != "无" ? result.data.credit_code : result.data.reg_number// 组织机构证件号,支持统一社会信用代码号和工商注册号（部分个体工商户）
                }
                var fourFactorsCompareResult = await this.restPostUrl(fourFactorsReqParam, settings.fourFactorsUrl() + "auth/organize/fourFactors/compare");
                // 请求失败
                if (fourFactorsCompareResult.code != 0) {
                    return system.getResult(null, "-zzzd08" + fourFactorsCompareResult.msg);
                }
                // 验证失败
                if (fourFactorsCompareResult.data.state != 1) {
                    return system.getResult(null, "-zzzd09" + fourFactorsCompareResult.msg);
                }
                // 记录检测结果 用来做检测记录用？？？暂时未做，表已建好在center-order/c_zzzd_test_business

                // 返回四要素请求结果
                return system.getResultSuccess();
            // 2020 0811 lin 新增 诊断宝相关
            case "manualEvaluation":
                opResult = await this.utilsDiagnosisSve.manualEvaluation(pobj, pobj.actionBody);
                break;
            case "diagnosisInfo":
                opResult = await this.utilsDiagnosisSve.diagnosisInfo(pobj, pobj.actionBody);
                break;
            case "diagnosisDetail":
                opResult = await this.utilsDiagnosisSve.diagnosisDetail(pobj, pobj.actionBody);
                break;
            case "enterpriseInfo":
                opResult = await this.utilsDiagnosisSve.enterpriseInfo(pobj, pobj.actionBody);
                break;
            case 'opSubmitNeed': // 下需求 2020 0813 lin 
                opResult = await this.utilsDiagnosisSve.opSubmitNeed(pobj, pobj.actionBody, req);
                break
            case 'opNeedList': // 需求列表 20 08 12 liang。 2020 0813 lin修改
                opResult = await this.utilsDiagnosisSve.opNeedList(pobj, pobj.actionBody, req);
                break
            case 'getItemByNeedNo': // 需求详情 20 08 12 liang
                opResult = await this.utilsDiagnosisSve.getItemByNeedNo(pobj);
                break
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = Zzzd;
