var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsTmOrderCallSve = system.getObject("service.utilsSve.utilsTmOrderCallSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "queryTradeProduceList"://2020 0907 lin 新增 ali查询 用户确认资料支付尾款，并更新订单状态
                opResult = await this.utilsTmOrderCallSve.queryTradeProduceList(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        console.log(opResult)
        return opResult;
    }

}
module.exports = ProductAPI;
