var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        console.log("11111",opResult)
        switch (action_type) {
            case "tmAccept"://2020 0828 lin 新增 ali商标交易 创建订单接口
                opResult = await this.utilsOrderSve.tmAccept(pobj, pobj.actionBody);
                break;
            case "tmRefuse"://2020 0828 lin 新增 ali商标交易 关闭订单接口
                opResult = await this.utilsOrderSve.tmRefuse(pobj, pobj.actionBody);
                break;
            case "tmStatus"://2020 0828 lin 新增 ali商标交易 订单查询
                opResult = await this.utilsOrderSve.tmStatus(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        console.log(opResult)
        return opResult;
    }

}
module.exports = ProductAPI;
