var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");

class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
        this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
    }

    /**
     * 接口跳转-POST请求
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "addOrder"://创建订单
                opResult = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
                //处理推送到峰擎
                // opType：值为query、add            
                this.pushNewFq(pobj, opResult);
                break;
            case "addOrderWeb"://创建订单 官网
                opResult = await this.utilsOrderSve.addOrderWeb(pobj, pobj.actionBody);
                break;
            case "getOrderInfo"://获取订单列表信息
                opResult = await this.utilsOrderSve.getOrderInfo(pobj, pobj.actionBody);
                break;
            case "getPathName":
                opResult = await this.utilsProductSve.getAllPathName(pobj);
                break;
            case "getOrderStatisticsByUappId":
                opResult = await this.utilsOrderSve.getOrdersStatisticsByUappId(pobj);
                break;
            case "getOrderStatisticsByProduct":
                opResult = await this.utilsOrderSve.getOrdersStatisticsByProduct(pobj);
                break;
            case "getOrderStatisticsByChannel":
                opResult = await this.utilsOrderSve.getOrdersStatisticsByChannel(pobj);
                break;
            case "getOrdersComparison":
                opResult = await this.utilsOrderSve.getOrdersComparison(pobj);
                break;
            case "getOrdersComparisonList":
                opResult = await this.utilsOrderSve.getOrdersComparisonList(pobj);
                break;
            case "getOrderDetails"://获取订单详情信息
                opResult = await this.utilsOrderSve.getOrderDetails(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryInfo"://获取订单交付信息
                opResult = await this.utilsOrderSve.getOrderDeliveryInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryFlowInfo"://获取订单交付流程信息
                opResult = await this.utilsOrderSve.getOrderDeliveryFlowInfo(pobj, pobj.actionBody);
                break;
            case "getOrderDeliveryFlowList"://获取订单交付流程列表信息
                opResult = await this.utilsOrderSve.getOrderDeliveryFlowList(pobj, pobj.actionBody);
                break;
            case "getOrderLogInfo"://获取订单日志信息
                opResult = await this.utilsOrderSve.getOrderLogInfo(pobj, pobj.actionBody);
                break;
            case "delOrder"://删除订单
                opResult = await this.utilsOrderSve.delOrder(pobj, pobj.actionBody);
                break;
            // case "getIcbcOrderDetails"://获取工商详情
            //     opResult = await this.utilsOrderSve.addOrder(pobj, pobj.actionBody);
            //     break;
            case "addUsuallyContacts"://添加常用联系人、申请人
                opResult = await this.utilsOrderSve.addUsuallyContacts(pobj, pobj.actionBody);
                break;
            case "delUsuallyContacts"://删除常用联系人、申请人
                opResult = await this.utilsOrderSve.delUsuallyContacts(pobj, pobj.actionBody);
                break;
            case "updateUsuallyContacts"://修改常用联系人、申请人
                opResult = await this.utilsOrderSve.updateUsuallyContacts(pobj, pobj.actionBody);
                break;
            case "getUsuallyContacts"://查询常用联系人、申请人
                opResult = await this.utilsOrderSve.getUsuallyContacts(pobj, pobj.actionBody);
                break;
            case "importOrders":
                opResult = await this.utilsOrderSve.importOrders(pobj, req);
                break;
            case "pushTest":
                opResult = await this.utilsOrderSve.pushTest(pobj, pobj.actionBody);
                break;
            case "receiveAliTmOrder"://接收阿里商标订单
                opResult = await this.utilsOrderSve.receiveAliTmOrder(pobj, pobj.actionBody);
                break;
            case "receiveFqbossTmOrder"://接收阿里商标订单
                opResult = await this.utilsOrderSve.receiveFqbossTmOrder(pobj, pobj.actionBody);
                break;
            case "receiveAliTmStatus"://接收阿里商标状态
                opResult = await this.utilsOrderSve.receiveAliTmStatus(pobj, pobj.actionBody);
                break;
            case "receiveAliTmOrderRefund"://接收阿里商标订单退款信息
                opResult = await this.utilsOrderSve.receiveAliTmOrderRefund(pobj, pobj.actionBody);
                break;
            case "getOrderIdFrom360":
                opResult = await this.utilsOrderSve.getOrderIdFrom360(pobj,pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

    async pushNewFq(pobj, result) {
        this.execClientNew.execLogs("pushNewFq-1", pobj, "center-channel-order-pushNewFq", result, null);
        if (result.status == 0 && result.data && result.data.channelOrderNo) {
            try {
                pobj.actionType = "getOrderInfoByChannelOrderNo";
                pobj.actionBody.channelOrderNo = result.data.channelOrderNo;
                await this.utilsOrderSve.pushNewFqByChannelOrderNo(pobj);
            } catch (e) {
                const stackStr = e.stack ? e.stack : JSON.stringify(e);
                this.execClientNew.execLogs("pushNewFq异常:", pobj, "center-channel-pushNewFq", null, stackStr);
            }
        }
    }
}

module.exports = ProductAPI;
