var WEBBase = require("../../web.base");
var system = require("../../../system");
class PolicyAPI extends WEBBase {
    constructor() {
        super();
        this.policySve = system.getObject("service.policy.policySve");
        this.wxTokenSve = system.getObject("service.common.wxTokenSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj,pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj,action_process, action_type, action_body, req) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "policyQuery"://政策检索
                opResult = await this.policySve.policyQuery(pobj);
                break;
            case "policyTypeQuery"://政策检索(根据政策类型检索)
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "submitPolicyNeed"://政策申请提报
                opResult = this.policySve.submitPolicyNeed(pobj);
                break;
            case "getPolicyNeedList"://政策需求列表
                opResult = this.policySve.getPolicyNeedList(pobj);
                break;
            case "submitPolicyNeedNotes"://申请信息备注提交
                opResult = this.policySve.submitPolicyNeedNotes(pobj);
                break;
            case "getWxSign"://获取微信签名信息
                opResult = this.policySve.getWxSign(action_body.url);
                break;
            case "getTokenAndOpenid"://通过code换取网页授权access_token，用于政策H5 oauth授权登录
                opResult = this.wxTokenSve.getTokenAndOpenid(action_body);
                break;
            case "submitPolicysubscribe"://提交政策订阅
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "delPolicysubscribe"://取消政策订阅
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "getPolicysubscribeList"://获取政策订阅列表
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "policyTypeCount"://政策类型统计计数
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "policySubscribeQuery"://政策订阅检索列表(通过订阅信息查询订阅的政策信息)
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "getPolicyBusinessFq"://政策商机（蜂擎）
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            case "getPolicyNeedInfo"://政策需求信息（icompany）
                opResult = this.policySve.reqPolicyApi(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = PolicyAPI;