const uuid = require('uuid/v4');

/**
 * 统一阿里返回结果
 */
class CtxBody {

    static success(res, data = {}) {
        const body = {
            requestId: uuid() || '',
            success: true,
            data,
            Code: data.Code || "200",
            errorCode: 'OK',
            errorMsg: '操作成功',
        }
        res.status(200).send(body);
    }

    static error(res, error) {
        let errorCode = error.code || 'UNKNOWN.EXCEPTION';
        let errorMsg = error.message || '发生未知异常';
        const body = {
            requestId: uuid() || '',
            success: false,
            data: {},
            errorCode: errorCode,
            errorMsg: errorMsg,
        }
        res.status(200).send(body);
    }
}

module.exports = CtxBody;