var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("service.common.oplogSve");
const regCfg = require("./regCfg")
//gongshang zhuce
class RegCenterOrderService extends AppServiceBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.channelApiUrl = settings.channelApiUrl();
    this.centerChannelUrl = settings.centerChannelUrl();
    this.appInfo = {
      aliyuntmtransfer: { appkey: settings.appKey, secret: settings.secret }
    };
  }

  // -------------提交reg需求--------laolan 2020.12.17-------百度reg接入使用--------start------------------
  async getCenterTokenByApp(appinfo) {
    var reqTokenUrl = this.centerChannelUrl + "/api/opreceive/accessAuth/getAppTokenByAppKey";
    var reqParam = appinfo;
    if (!reqParam || !reqParam.uapp_key || !reqParam.uapp_secret) {
      return system.getResult(null, "reqType类型有误，请求失败");
    }
    var param = {
      "actionType": "getAppTokenByAppKey",
      "actionBody": {
        "appkey": reqParam.uapp_key,
        "secret": reqParam.uapp_secret
      }
    };
    
    var rtn = await this.execlient.execPost(param, reqTokenUrl);
    if (!rtn.stdout) {
      return system.getResult(null, "获取token失败");
    }
    var tokenResult = JSON.parse(rtn.stdout);
    return tokenResult;
  }

  async reqcenterchannel2(pobj) {
    console.log('reqcenterchannel2----',pobj)
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "无效应用",
        "errorCode": "ok"
      };
    }
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "getTokenInfo fail",
        "errorCode": "ok"
      };
    }
    var userpin = "";
    //传手机号
    if(pobj.phone&&!pobj.mobile){
      pobj.mobile=pobj.phone;
    }else{//没传手机号就自己去查渠道唯一码
      var reqData = {
        actionType: "selectNeedInfo",
        actionBody: {
          channelNeedNo:pobj.intentionBizId
        }
      }
      var needInfoUrl = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
      var needInfoRes = await this.execlient.execPostTK(reqData, needInfoUrl, tokenInfo.data.token);
      if(needInfoRes.status == 0){
        pobj.mobile =  needInfoRes.channelNeedNo
      }
    }

    if (pobj.mobile) {
      //有传手机号就直接获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.mobile
        }
      };
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return system.getResultFail(-99, "获取userpin失败");
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        return system.getResultFail(-88, "获取userpin失败!!");
      }
      
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
    var token = tokenInfo.data.token;
    var rtn = null;
    if (userpin) {
      rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    } else {
      rtn = await this.execlient.execPostTK(sobj, url, token);
      if (rtn.status == 0) {
        return {
          "requestId": rtn.requestId,
          "success": true,
          "errorMsg": "",
          "errorCode": "ok"
        };
      } else {
        return {
          "requestId": rtn.requestId,
          "success": false,
          "errorMsg": rtn.msg,
          "errorCode": "ok"
        };
      }
    }
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }

    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }
  //百度reg 2.3 请求
  async regOrderStatus(pobj) {
    if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "无效应用",
        "errorCode": "ok"
      };
    }
    // 获取app token
    // var tokenInfo = await this.getCenterToken();
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
      // 引用属性，channel依赖bizId order依赖intentionBizId
      pobj.intentionBizId = pobj.bizId
      if (pobj.isDirectBuy==1){//直购
        userparam.actionBody.channelUserId = pobj.phone
        userparam.actionBody.mobile = pobj.phone
        userparam.actionBody.userName = pobj.phone
        pobj.publishMobile = pobj.phone
        pobj.channelTypeCode = pobj.consultType;
        if (pobj.area) {
          // pobj.area = regCfg.baiduArea[pobj.area]
          pobj.area = pobj.area
        }
        pobj['province'] = pobj.area;
      }else {
        var sobj = {
          "actionType": "getItemByChannelSolutionNo",
          "actionBody": pobj
        }
        // getItemByChannelSolutionNo
        var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
        var result = await this.execlient.execPostTK(sobj, url, token);
        if (result.status != 0) {
          return {
            "requestId": result.requestId,
            "success": false,
            "errorMsg": result.msg,
            "errorCode": "ok"
          };
        }
        userparam.actionBody.channelUserId = result.data.channelUserId
        userparam.actionBody.mobile = result.data.publishMobile
        userparam.actionBody.userName = result.data.publishMobile
        pobj.publishMobile = result.data.publishMobile;
        pobj.channelNeedNo = result.data.channelNeedNo;
        
        pobj.needNo = result.data.needNo;
        pobj.channelTypeCode = result.data.channelTypeCode;
        pobj['province'] = result.data.solutionProvince;//北京(新购)?

    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return {
        "requestId": userpinResultTmp.requestId,
        "success": false,
        "errorMsg": userpinResultTmp.msg,
        "errorCode": "ok"
      };
    }
    //regOrderStatus
    var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
    var sobj = {
      "actionType": "regOrderStatus",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token,userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    return {
      "requestId": result.requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    };
  }
  //百度reg 2.4 请求 关闭reg订单
  async regOrderClose(pobj) {
    if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "无效应用",
        "errorCode": "ok"
      };
    }
    // 获取app token
    // var tokenInfo = await this.getCenterToken();
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var sobj = {
      "actionType": "getSolutionByChannelOrderNo",
      "actionBody": pobj
    }
    // getItemByChannelSolutionNo
    var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
    var result = await this.execlient.execPostTK(sobj, url, token);
    if (result.status != 0 || !result.data) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    if(!result.data.solutionContent || !result.data.solutionContent.customerInfo || !result.data.solutionContent.customerInfo.publishMobile){
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": "方案客户信息有误",
        "errorCode": "ok"
      };
    }
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {
        channelUserId:result.data.solutionContent.customerInfo.publishMobile,
        mobile:result.data.solutionContent.customerInfo.publishMobile,
        userName:result.data.solutionContent.customerInfo.publishMobile
      }
    };
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, token);
    if (userpinResultTmp.status != 0) {
      return {
        "requestId": userpinResultTmp.requestId,
        "success": false,
        "errorMsg": userpinResultTmp.msg,
        "errorCode": "ok"
      };
    }
    var closeobj = {
      "actionType": "regOrderClose",
      "actionBody": pobj
    }
    var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
    var rtn = await this.execlient.execDataPostByTokenUserPin(closeobj, url, token,userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    return {
      "requestId": result.requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    };
  }
// -------------提交reg需求--------laolan 2020.12.17-------百度reg接入使用--------end------------------
  async paySuccess(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": regCfg.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
      // return { "message": "success", "data": {}, "code": 200 }
    }
    var userpin = "";
    if (pobj.phone) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.phone,
          "mobile": pobj.phone,
          "userName": pobj.phone
        }
      };
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": regCfg.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": regCfg.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/ic/springBoard";
    var token = tokenInfo.data.token;
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      // return { "message": "网络错误", "data": {}, "code": -102 }
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      // return { "message": "true", "data": {}, "code": 200 }
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      // return { "message": result.msg, "data": {}, "code": -102 }
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }

  async orderClose(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }

    var url = settings.centerChannelUrl() + "/api/opreceive/ic/springBoard";
    var token = tokenInfo.data.token;
    var rtn = await this.execlient.execPostTK(sobj, url, token);
    if (rtn.status == 0) {
      return {
        "requestId": rtn.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": rtn.requestId,
        "success": false,
        "errorMsg": rtn.msg,
        "errorCode": "ok"
      };
    }
  }

  //icp 2.3 请求
  async queryOrderState(pobj) {
    // 获取app token
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    // 引用属性，channel依赖bizId order依赖intentionBizId
    pobj.intentionBizId = pobj.bizId
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
    if (pobj.isDirectBuy === "true"){//直购
      if (!pobj.mobile){
        var sobj = {
          "actionType": "getSolutionByChannelSolutionNo",
          "actionBody": pobj
        }
        var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
        var result = await this.execlient.execPostTK(sobj, url, token);
        if (result.status != 0) {
          return {
            "requestId": result.requestId,
            "success": false,
            "errorMsg": result.msg,
            "errorCode": "ok"
          };
        }
        pobj.mobile = result.data.solutionContent.customerInfo.publishMobile
      }
      userparam.actionBody.channelUserId = pobj.mobile
      userparam.actionBody.mobile = pobj.mobile
      userparam.actionBody.userName = pobj.mobile
      pobj.publishMobile = pobj.mobile
      pobj.channelTypeCode = pobj.bizId.startsWith("EDI")?7:5;
      //pobj.province = pobj.companyLocation+`（${pobj.actionType}）`
      pobj.province = pobj.area
    }else {
      var sobj = {
        "actionType": "getItemByChannelSolutionNo",
        "actionBody": pobj
      }
      // getItemByChannelSolutionNo
      var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
      var result = await this.execlient.execPostTK(sobj, url, token);
      if (result.status != 0) {
        return {
          "requestId": result.requestId,
          "success": false,
          "errorMsg": result.msg,
          "errorCode": "ok"
        };
      }
      userparam.actionBody.channelUserId = result.data.channelUserId
      userparam.actionBody.mobile = result.data.publishMobile
      userparam.actionBody.userName = result.data.publishMobile
      pobj.publishMobile = result.data.publishMobile;
      pobj.channelNeedNo = result.data.channelNeedNo;
      pobj.needNo = result.data.needNo;
      pobj.channelTypeCode = result.data.channelTypeCode;
      pobj.province = result.data.solutionProvince;//北京(新购)?
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return {
        "requestId": userpinResultTmp.requestId,
        "success": false,
        "errorMsg": userpinResultTmp.msg,
        "errorCode": "ok"
      };
    }
    // icpNotify
    var url = settings.centerChannelUrl() + "/api/action/regapi/springBoard";
    var sobj = {
      "actionType": "icpNotify",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token,userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": regCfg.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    return {
      "requestId": result.requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    };
  }
}
module.exports = RegCenterOrderService;
