{
    template: '${tmpl}',
        data: function () {
    var validMethod = (rule, value, callback) => {
        return this.validfileds(rule, value, callback);
    };

    return {
        etemplate: {isEnabled:true},
        editTitle: "新增",
        showEdit: false,
        saveLoading: false,

        nameLoading: false,
        nameList: [],
        nameMap: [],

        nameLoading2: false,
        nameList2: [],
        nameMap2:[],
        uploadResult: null,
        fileList:[],

        mainList:[],
        search: {
            list: [],
            currentPage: 1,
            pageSize: 20,
            total : 0,
            name:'',
        },
        rules: {
            ecompanyName : [
                { required: true, message: '请输入公司名称', trigger: 'blur' },
                { validator: validMethod, trigger: 'blur' }
            ],
            codeurl: [
                { required: true, message: '请上传签约协议', trigger: 'blur' },
            ],
            a : [],
        },
    }
},
    mounted: function () {
        this.resetSearch(true);
        this.getMainList();
    },
    created: function () {},
    methods: {
        getEmptySearch() {
            return {
                list: [],
                currentPage: 1,
                pageSize: 20,
                total : 0,
                name:'',
            }
        },
        resetSearch() {
            this.search = this.getEmptySearch();
            this.getList();
        },
        tableHeaderColor({ row, column, rowIndex, columnIndex }) {
            if (rowIndex === 0) {
                return 'background-color: #F5F5F5;color: #2F2F2F;font-size: 14px;font-weight:400;'
            }
        },
        opSearch() {
            this.search.currentPage = 1;
            this.search.total = 0;
            this.getList();
        },
        getMainList() {
            var self = this;
            this.$root.postReq("/web/ecompanymainCtl/all", {
            }).then(function (d) {
                if (d.status == 0) {
                    self.mainList = d.data || [];
                } else {
                }
            });
        },
        getList() {
            var self = this;
            var params = this.getParams();
            this.$root.postReq("/web/enttemplateCtl/signList", {
                search: params
            }).then(function (d) {
                if (d.status == 0) {
                    self.search.list = d.data.rows || [];
                    self.search.total = d.data.count || 0;
                } else {
                }
            });
        },
        exportList() {
            window.open("/web/enttemplateCtl/signExport" + this.getExportParams());
        },
        getParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return params;
        },
        getExportParams() {
            var params = {};
            for(var f in this.search) {
                if(f == "list") {
                    continue;
                }
                params[f] = this.search[f];
            }
            return "?search=" + encodeURIComponent(JSON.stringify(params));
        },

        onColFormater(row, column, cellValue, index) {
            return cellValue || "---";
        },
        getEtemplate(id) {
            var self = this;
            self.$root.postReq("/web/enttemplateCtl/info", {
                id: id,
            }).then(function (d) {
                if (d.status == 0) {
                    if(d.data) {
                        d.data.isEnabled = d.data.isEnabled ? true : false;
                    }
                    self.etemplate = d.data;
                    if(self.etemplate.codeurl) {
                        self.fileList = [{
                            name: "模板文件",
                            url: self.etemplate.codeurl,
                        }];
                    } else {
                        self.uploadResult = null;
                    }
                    console.log(self.uploadResult);
                } else {
                    self.$message.warning(d.msg || `您的网络不稳定, 请稍后重试`);
                }
            });
        },
        toDetail(id) {
        },
        openEdit(id) {
            this.clearUpload();
            if(id) {
                this.editTitle = "修改";
                this.getEtemplate(id);
            } else {
                this.editTitle = "修改";
                this.etemplate = {isEnabled:true};
            }
            this.showEdit = true;
        },
        handleSizeChange(val) {
            this.search.pageSize = val;
            this.resetSearch();
        },
        handleCurrentChange(val) {
            this.search.currentPage = val;
            this.getList();
        },
        validfileds(rule, value, callback) {
            var self = this;
            if(rule.field == "ecompanyName") {
                if(!self.etemplate.entcompany_id) {
                    return callback(new Error("请重新选择公司名称"));
                }
            }
            return callback();
        },
        nameChange(val) {
            var self = this;
            var item = self.nameMap[val];
            self.search.entcompany_id = (item || {}).id || "";
        },
        nameChange2(val) {
            var self = this;
            var item = self.nameMap2[val];
            self.etemplate.entcompany_id = (item || {}).id || "";
        },
        getCompanyNames(query) {
            var self = this;
            self.nameLoading = true;
            self.$root.postReq("/web/ecompanyCtl/suggest", {
                name: query
            }).then(function (d) {
                self.nameLoading = false;
                self.nameList = d.data || [];
                self.nameMap = [];
                for(var item of self.nameList) {
                    self.nameMap[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading = false;
            }, 15000);
        },
        getCompanyNames2(query) {
            var self = this;
            self.nameLoading2 = true;
            self.$root.postReq("/web/ecompanyCtl/suggest", {
                name: query
            }).then(function (d) {
                self.nameLoading2 = false;
                self.nameList2 = d.data || [];
                self.nameMap2 = [];
                for(var item of self.nameList2) {
                    self.nameMap2[item.name] = item;
                }
            });
            setTimeout(() => {
                self.nameLoading2 = false;
            }, 15000);
        },

        clearUpload() {
            var self = this;
            self.uploadResult = null;
            self.etemplate.codeurl = "";
            if(self.$refs.upload3 && self.$refs.upload3.$refs && self.$refs.upload3.$refs.upload) {
                self.$refs.upload3.$refs.upload.clearFiles();
            }
        },
        uploadsuccess(v) {
            if(!v || !v[0] || !v[0].url) {
                this.$message.warning("上传失败");
                return;
            }
            this.etemplate.codeurl = v[0].url;
        },

        saveTemplate() {
            var self = this;
            self.$refs.etemplate.validate((valid) => {
                if (valid) {
                    self.saveLoading = true;
                    setTimeout(() => {
                        self.saveLoading = false;
                    }, 15000);
                    self.$root.postReq("/web/enttemplateCtl/mysave", self.etemplate).then(function (d) {
                        if (d.status == 0) {
                            self.$message.success(`保存成功`);
                            self.showEdit = false;
                            self.getList();
                        } else {
                            self.$alert(d.msg || '保存失败', '提示', {
                                confirmButtonText: '确定',
                                callback: action => {}
                            });
                        }
                        self.saveLoading = false;
                    });
                } else {
                    self.saveLoading = false;
                    return false;
                }
            });
        },
    },
    vname: "gsb-ecompanyadmin"
}