    {
    template: '${tmpl}',
    data: function () {
        return {
            statTime: '0',
            timeOptions:[],
            sqxql : 0,
            fdl: 0,
            jdl:0,
            cgqyl:0,
            jyze:0,
            jyzeunit: '万',
            eventList:[],
            messageList:[],
            eventPage: {
                total: 0,
                currentPage:1,
                pageSize:5,
            },
            messagePage: {
                total: 0,
                currentPage:1,
                pageSize:5,
            }
        }
    },
    mounted: function () {
        this.initTimeOptions();
        this.statData();
        this.getEvents();
        this.getMessages();
    },
    created: function () {
    },
    methods: {
        statData() {
            this.statSQXQL();
            this.statFDL();
            this.statJDL();
            this.statCGQYL();
            this.statJYZE();
        },
        initTimeOptions(){
            this.timeOptions = [{
                value: '0',
                label: '总量'
              }, {
                value: '1',
                label: '本年度'
              }, {
                value: '2',
                label: '本季度'
              }, {
                value: '3',
                label: '本月'
              }
            ];
        },
        changeStatTime() {
            this.statData();
        },
        statSQXQL() {
            var self = this;
            this.$root.postReq("/web/ejobCtl/statSQXQL", {
                statTime: self.statTime || "0",
            }).then(function (d) {
                if (d.status == 0) {
                    self.sqxql = d.data.count || 0;
                }
            });
        },
        statFDL() {
            var self = this;
            this.$root.postReq("/web/ejobCtl/statFDL", {
                statTime: self.statTime || "0",
            }).then(function (d) {
                if (d.status == 0) {
                    self.fdl = d.data.count || 0;
                }
            });
        },
        statJDL() {
            var self = this;
            this.$root.postReq("/web/ejobCtl/statJDL", {
                statTime: self.statTime || "0",
            }).then(function (d) {
                if (d.status == 0) {
                    self.jdl = d.data.count || 0;
                }
            });
        },
        statCGQYL() {
            var self = this;
            this.$root.postReq("/web/ejobCtl/statCGQYL", {
                statTime: self.statTime || "0",
            }).then(function (d) {
                if (d.status == 0) {
                    self.cgqyl = d.data.count || 0;
                }
            });
        },
        statJYZE() {
            var self = this;
            this.$root.postReq("/web/ejobCtl/statJYZE", {
                statTime: self.statTime || "0",
            }).then(function (d) {
                if (d.status == 0) {
                    var c = Number(d.data.count|| 0);
                    if(c >= 10000) {
                        self.jyze = parseFloat((c / 10000).toFixed(2));
                        self.jyzeunit = "万元";
                    } else {
                        self.jyze = c;
                        self.jyzeunit = "元";
                    }
                }
            });
        },
        getEvents() {
            var self = this;
            this.$root.postReq("/web/ecompanyeventCtl/handingList", {
                currentPage : self.eventPage.currentPage,
                pageSize : self.eventPage.pageSize
            }).then(function (d) {
                if (d.status == 0) {
                    self.eventPage.total = d.data.count;
                    self.eventList = d.data.rows || [];
                }
            });
        },
        eventCurrentChange(val) {
            this.eventPage.currentPage = Number(val);
            this.getEvents();
            
        },
        toaudit(item) {
            var self = this;
            self.$root.postReq("/web/ejobapplyCtl/applyInfo", {
                id : item.biz_id,
            }).then(function (d) {
                if (d.status == 0) {
                    self.$root.pushx({
                        title : "查看详情",
                        name : "/ejobapplys",
                        params: {ejobId: d.data.ejob_id, applyId: d.data.id},
                    });
                }
            });

            /*

            this.$root.pushx({
                title : "查看详情",
                name : "/ejobapplys",
                params: {ejobId: item.id},
            });

                this.$root.pushx({
                    title : "查看订单",
                    name : "/ecommissionall",
                    params: {ecompanyId: row.id},
                });
             */
        },
        getMessages() {
            var self = this;
            this.$root.postReq("/web/emessageCtl/entMessageList", {
                currentPage : self.messagePage.currentPage,
                pageSize : self.messagePage.pageSize
            }).then(function (d) {
                if (d.status == 0) {
                    self.messagePage.total = d.data.count;
                    self.messageList = d.data.rows || [];
                }
            });
        },
        messageCurrentChange(val) {
            this.messagePage.currentPage = Number(val);
            this.getMessages();
        },

    },  
    vname: "gsb-enthome"
}