var app = new Vue({
  el: "#app",
  data: function () {

    var validmethod = (rule, value, callback) => {
      if (rule.field == "userName") {
        if (!value) {
          return callback(new Error('请输入手机号'));
        } else {
          callback();
          this.patnerValid();
        }
      } else {
        if (!value) {
          return callback(new Error('请输入密码'));
        }
        callback();
      }
    };
    return {
      domainUrl:"",
      isAggree: false,
      showAggree: false,
      loginForm: {
        userName: '',
        password: '',
      },
      rules: {
        userName: [
          { validator: validmethod, trigger: 'blur' }
        ],
        password: [
          { validator: validmethod, trigger: 'blur' }
        ],
      },
    }
  },
  created: function () {
  },
  mounted: function () {
    var harr = window.location.href.split("//");
    this.domainUrl = harr[0] + "//" + window.location.host;
    console.log(this.domainUrl);
  },

  methods: {
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    btnclick: function (pfm, code) {
    },
    login() {
      var self = this;
      if(self.showAggree) {
        self.loginForm.aggree = self.isAggree;
      }
      this.$refs['loginForm'].validate((valid) => {
        console.log(valid);
        if (valid) {
            //处理登录逻辑
            self.$root.postReq("/web/userCtl/loginhhr",{u:self.loginForm}).then(function(d){
              if(d.status==0) {
                window.location.href = self.domainUrl;                
                // self.$root.pushx({nane:"/home", notab:true});
              }  else {
                  self.$message.warning(d.msg || "登录失败, 请稍候重试");
              }
            });
        } else {
          return false;
        }
      });
    },
    patnerValid() {
      var self = this;
      //调用接口,根据用户名判断是否协议
      this.$root.postReq("/web/userCtl/patnerValid", {
        userName: self.loginForm.userName
      }).then(rd => {
        self.showAggree = false;
        if (rd.status == 0) {
          if (rd.data == "1") {
            self.showAggree = true;
          }
        }
      });
    },
  },
});