const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");

class EsettleofflineitemService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EsettleofflineitemService));
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.esettleoffline_id) {
      where.esettleoffline_id = params.esettleoffline_id;
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "esettleoffline_id", "id_no", "id_name", "acc_no", "open_bank", 
    "amt", "actual_amt", "total_amt", "income_rate", "income_tax", "service_tax", "added_value_tax", "remark"
    ];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {
      }
      system.f2y4list(page.rows, ["amt", "actual_amt", "total_amt", "income_tax", "service_tax", "added_value_tax"]);
    }
    return page;
  } 
}
module.exports = EsettleofflineitemService;