const system = require("../../system");
const ServiceBase = require("../sve.base");
class EpartneradvService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EpartneradvService));
  }

  async nameByPartnerIds(ids) {
    var result = [];
    if(!ids || ids.length == 0) {
      return result;
    }

    var sql = "SELECT epartner_id, name FROM `c_epartner_adv` WHERE epartner_id IN (:partnerIds) ";
    var list = await this.dao.customQuery(sql, {partnerIds:ids});

    for(var item of list) {
      var key = "partner_" + item.epartner_id;
      var nlist = result[key];
      if(!nlist) {
        nlist = [];
      }
      nlist.push(item.name);
      result[key] = nlist;
    }

    return result;
  }
}
module.exports = EpartneradvService;