const system=require("../../system");
const Dao=require("../dao.base");
class EjobDao extends Dao{
  constructor(){
    super(Dao.getModelName(EjobDao));
  }

  async findMapByIds(ids, attrs) {
    var result = [];
    if(!ids || ids.length == 0) {
      return result;
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM c_ejob where id IN (:ids) ";
    var list = await this.customQuery(sql, {ids:ids});
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result["id_" + item.id] = item;
    }
    return result;
  }

  // 导入名单的数据结构查询公司和职位
  async findMapByRosterBiz(ecompanyNames, ejobNames) {
    var result = [];
    if(!ecompanyNames || ecompanyNames.length == 0 || !ejobNames || ejobNames.length == 0) {
      return result;
    }

    var sql = [];
    sql.push("SELECT");
    sql.push("t1.id, t1.ecompany_id, t2.name AS ecompany_name, t1.name AS ejob_name");
    sql.push("FROM `c_ejob` t1 ");
    sql.push("INNER JOIN `c_ecompany` t2 ON t1.`ecompany_id` = t2.id");
    sql.push("WHERE t2.`name` IN (:ecompanyNames) AND t1.`name` IN (:ejobNames)");
    var list = await this.customQuery(sql.join(" "), {ecompanyNames: ecompanyNames, ejobNames: ejobNames});
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result[item.ecompany_name + "___" + item.ejob_name] = item;
    }
    return result;
  }

}
module.exports=EjobDao;
