var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
const moment = require("moment");

const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
class esettleofflineCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(esettleofflineCtl));
    this.userSve = system.getObject("service.userSve");
    this.epartnerSve = system.getObject("service.epartnerSve");
    this.ecompanySve = system.getObject("service.ecompanySve");
  }

  async save(queryobj, qobj, req) {
    var id = qobj.id;
    var  settle = {};
    if(id) {
      settle.id = id;
    }

    this.buildSettle(settle, qobj);
    settle.opid = req.session.user.id;

    var rs = await this.service.saveSettle(settle);
    if(rs.code) {
      return system.getResult2(1);
    }
    return system.getErrResult2(rs.msg || "文件解析失败");
  }

  buildSettle(settle, qobj) {
    settle.ecompany_id = qobj.ecompany_id;
    settle.ecompanyName = qobj.ecompanyName;
    settle.pay_complete_time = qobj.pay_complete_time;
    settle.pay_time = qobj.pay_complete_time;
    settle.month = Number(moment(qobj.pay_complete_time).format("YYYYMM"));;
    settle.amt = (Number(qobj.amt) * 100).toFixed(0);
    settle.actual_amt = (Number(qobj.actual_amt) * 100).toFixed(0);

    settle.service_rate = qobj.service_rate;
    settle.service_tax = (Number(qobj.service_tax) * 100).toFixed(0);
    settle.added_value_tax = (Number(qobj.added_value_tax) * 100).toFixed(0);
    settle.open_bank = qobj.open_bank;
    settle.bankno = qobj.bankno;
    settle.fileurl = qobj.fileurl;
    settle.sourceType = qobj.sourceType;

    if(!qobj.id) {
      settle.epartner_id = 0;
      settle.user_id = 0;
      settle.out_trade_no = ""
      settle.tbl_order_id = 0;
      settle.busi_id = 0;
      settle.deduct_amt = 0;
    }
  }

  async allList(queryobj, qobj, req) {
    try {
      var params = this.getSettleParams(qobj.search);
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  getSettleParams(search) {
    var params = search || {};
    if(this.trim(params.payBegin)) {
      params.payBegin = this.trim(params.payBegin) + " 00:00:00";
    }
    if(this.trim(params.payEnd)) {
      params.payEnd = this.trim(params.payEnd) + " 23:59:59";
    }

    if(this.trim(params.createBegin)) {
      params.createBegin = this.trim(params.createBegin) + " 00:00:00";
    }
    if(this.trim(params.createEnd)) {
      params.createEnd = this.trim(params.createEnd) + " 23:59:59";
    }
    
    if(params.amtBegin) {
      params.amtBegin = Number(params.amtBegin) * 100;
    }
    if(params.amtEnd) {
      params.amtEnd = Number(params.amtEnd) * 100;
    }
    return params;
  }

  async parseItems(queryobj, qobj, req) {
    try {
      var rs = await this.service.parseItems(req.session.user.id, qobj.url, qobj.pay_complete_time || "");
      if(rs.code == 0) {
        return system.getErrResult2(rs.msg || "文件解析失败");
      }

      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statOfflineSettle(queryobj, qobj, req) {
    var loginUser = req.session.user;
    if(!loginUser.isBpoManager && !loginUser.isAdmin) {
      return system.getResult2({});
    }

    try {
      var params = qobj.search || {};

      if(params.month) {
        params.month = Number(params.month.replace("-", ""));
      }

      var rs = await this.service.statOfflineSettle(params);
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
}
module.exports = esettleofflineCtl;