var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require('moment');
class EcompanyworkloadCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EcompanyworkloadCtl));
  }

  async info(queryobj, qobj, req) {
    try {
      var info = await this.service.getById(qobj.id);
      return system.getResult2(info);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  async companylist(queryobj, qobj, req) {
    var params = qobj.search || {};
    var ecompany = req.session.ecompany;
    if (!ecompany) {
      return system.getResult2({count: 0, rows:[]});
    }

    try {
      params.ecompany_id = ecompany.id;
      var rs = await this.service.pageByCondition(params);
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  async zccompanylist(queryobj, qobj, req) {
    var params = qobj.search || {};

    try {
      var rs = await this.service.pageByCondition(params);
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  async mysave(queryobj, qobj, req) {
    qobj = qobj || {};
    var ecompany = req.session.ecompany;
    if (!ecompany) {
      return system.getErrResult2("请先做企业认证");
    }

    try {
      var workload;
      if(qobj.id) {
        workload = await this.service.findById(qobj.id);
        workload.name = qobj.name;
        workload.url = qobj.url;
        workload.updated_at = new Date();
        workload.month = Number(qobj.month.replace("-", ""));
        await workload.save();
      } else {
        workload = {
          ecompany_id: ecompany.id,
          name: qobj.name,
          url: qobj.url,
          month: Number(qobj.month.replace("-", "")),
        }
        workload = await this.service.create(workload);
      }
      return system.getResult2(workload);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async zcsave(queryobj, qobj, req) {
    qobj = qobj || {};
    try {
      var workload;
      if(qobj.id) {
        workload = await this.service.findById(qobj.id);
        workload.name = qobj.name;
        workload.url = qobj.url;
        workload.ecompany_id = qobj.ecompany_id || 0;
        workload.updated_at = new Date();
        workload.month = Number(qobj.month.replace("-", ""));
        await workload.save();
      } else {
        workload = {
          ecompany_id: qobj.ecompany_id,
          name: qobj.name,
          url: qobj.url,
          month: Number(qobj.month.replace("-", "")),
        }
        workload = await this.service.create(workload);
      }
      return system.getResult2(workload);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

}
module.exports = EcompanyworkloadCtl;