#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020/3/14 16:37
# @Author  : fanhui
# @File    : GetLicenseDataForImage.py
# @Software: PyCharm

from dao.online_GetlicenseImage_es import online_Getlicense_Es
from common.crm_change_standard import getStandardName
from flask import request,jsonify
from common import re_companyName

"""证照信息"""
#检索高新技术企业ES
def GetGXLicensesFromES(companyname):
    online_Getlicense = online_Getlicense_Es()
    print("证照es",companyname)
    license_result_list=[]

    licensesinfo1 = online_Getlicense.select_GXLicenses(companyname)
    if licensesinfo1["hits"]["hits"]:
        for row in licensesinfo1["hits"]["hits"]:
            if row['_source']["techType"]:
                license_name="高新技术企业"  # 证照名称
            else:
                license_name = "—"  # 证照名称
            if row['_source']["certificateNo"]:
                certificateNo=row['_source']["certificateNo"]#证照编号
            else:
                certificateNo = "—"  #证照编号
            if row['_source']["year"]:
                begin_date = row['_source']["year"]  # 开始时间
            else:
                begin_date = "—"  #开始时间
            license_result = {
                "license_name": license_name,
                "certificateNo": certificateNo,
                "begin_date": begin_date,
                "end_date": "—"
            }
            license_result_list.append(license_result)
    return license_result_list


#检索游戏类证照ES
def GetgameLicensesFromES(companyname):
    print("游戏类证照es")
    license_result_list1=[]
    online_Getlicense = online_Getlicense_Es()
    licensesinfo1 = online_Getlicense.select_gameLicenses_1(companyname)
    if licensesinfo1["hits"]["hits"]:
        for row in licensesinfo1["hits"]["hits"]:
            if row['_source']["publishing_record"]:
                license_name="网络游戏运营备案"  # 证照名称
            else:
                license_name = "—"  # 证照名称
            if row['_source']["symbol"]:
                certificateNo=row['_source']["symbol"]#证照编号
            else:
                certificateNo = "—"  #证照编号
            if row['_source']["publish_time"]:
                begin_date = row['_source']["publish_time"]  # 开始时间
            else:
                begin_date = "—"  #开始时间
            license_result = {
                "license_name": license_name,
                "certificateNo": certificateNo,
                "begin_date": begin_date,
                "end_date": "—"
            }
            license_result_list1.append(license_result)
    license_result_list2 = []
    licensesinfo1 = online_Getlicense.select_gameLicenses_2(companyname)
    if licensesinfo1["hits"]["hits"]:
        for row in licensesinfo1["hits"]["hits"]:
            if row['_source']["publishing_record"]:
                license_name = "网络游戏出版备案"  # 证照名称
            else:
                license_name = "—"  # 证照名称
            if row['_source']["symbol"]:
                certificateNo = row['_source']["symbol"]  # 证照编号
            else:
                certificateNo = "—"  # 证照编号
            if row['_source']["publish_time"]:
                begin_date = row['_source']["publish_time"]  # 开始时间
            else:
                begin_date = "—"  # 开始时间
            license_result = {
                "license_name": license_name,
                "certificateNo": certificateNo,
                "begin_date": begin_date,
                "end_date": "—"
            }
            license_result_list2.append(license_result)
    license_result_list=license_result_list1+license_result_list2
    return license_result_list



#检索高新技术企业ES
def GetICPLicensesFromES(companyname):
    print("ICP证照es")
    license_result_list=[]
    online_Getlicense = online_Getlicense_Es()
    licensesinfo1 = online_Getlicense.select_ICPLicenses(companyname)
    if licensesinfo1["hits"]["hits"]:
        for row in licensesinfo1["hits"]["hits"]:
            if row['_source']["licence"]:
                license_name=row['_source']["licence"] # 证照名称
            else:
                license_name = "—"  # 证照名称
            if row['_source']["licence_no"]:
                certificateNo=row['_source']["licence_no"]#证照编号
            else:
                certificateNo = "—"  #证照编号
            if row['_source']["start_date"]:
                begin_date = row['_source']["start_date"]  # 开始时间
            else:
                begin_date = "—"  #开始时间
            if row['_source']["end_date"]:
                end_date = row['_source']["end_date"]  # 截止时间
            else:
                end_date = "—"  #截止时间

            license_result = {
                "license_name": license_name,
                "certificateNo": certificateNo,
                "begin_date": begin_date,
                "end_date": end_date
            }
            license_result_list.append(license_result)

    return license_result_list


def getlicenceInfo(server):
    @server.route('/gsb/api/GetLicenseFromEs', methods=['POST'])
    def GetLicenseInfo():
        print("接口调用--------查询企业证照信息")
        if request.method == 'POST':
            requestdata = request.json
            print(requestdata)
            companyname = requestdata.get('companyname')
            standard_company_name = getStandardName(companyname)
            print('证照companyname',companyname)
            companyname = re_companyName.strQ2B(standard_company_name)
            LicenseInfo1= GetGXLicensesFromES(companyname)
            LicenseInfo2 = GetgameLicensesFromES(companyname)
            LicenseInfo3 = GetICPLicensesFromES(companyname)
            license_result=LicenseInfo1+LicenseInfo2+LicenseInfo3
            return jsonify(license_result)

# server.run(host='172.21.0.2', port=9000, debug=True)
# server.run(host='127.0.0.1', port=9000, debug=True)