#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020/3/19 10:54
# @Author  : fanhui
# @File    : GetImageFromSql.py
# @Software: PyCharm

"""企业画像和推荐商机"""

#读取数据库，获取画像标签
from flask import request,jsonify
from dao.GetImageFromSql_dao import Lable_Product_Dao
from common.crm_change_standard import getStandardName
from db.mod_db import DataBase
from common import re_companyName

#检索企业画像信息
def GetImageFromSql(companyname):
    print(companyname,"===========获取公司名称查询画像信息")
    # 查询数据库
    image_result = [] #画像列表
    try:
        # 执行SQL语句
        lable = Lable_Product_Dao()
        # 获取所有配置列表
        Allproduct_rules = lable.select_label(companyname)
        print(Allproduct_rules,"=====")
        for row in Allproduct_rules:
            # 获取所有规则
            image_result=row['company_lable']
            print(image_result)
    except:
        return ("没有查询到该公司画像信息")
    finally:
        DataInfo = DataBase()
        DataInfo.close()
    if image_result:
        image_result = image_result.replace("[","").replace("]","").replace('"',"").replace("'","").replace("，",",")
        imageresult=list(image_result.split(","))
        print(type(imageresult),"%%%%%%%")
    else:imageresult=image_result
    return imageresult

#检索产品信息
def GetProductFromSql(companyname):
    print(companyname,"===========获取公司名称查询产品推荐信息")
    # 查询数据库
    product_result = [] #产品列表
    try:
        product = Lable_Product_Dao()
        Allproduct_rules = product.select_product(companyname)
        print(Allproduct_rules)
        for row in Allproduct_rules:
            # 获取所有规则
            product_result=row['product_result']
            # print(type(product_result),product_result)
    except:
        return ("没有查询到该公司产品推荐信息")
    finally:
        DataInfo = DataBase()
        DataInfo.close()
    if product_result:
        product_result = product_result.replace("[","").replace("]","").replace('"',"").replace("'","").replace("，",",").replace(" ","")
        print(product_result)
        productresult=list(product_result.split(","))
        print(type(productresult),"%%%%%%%")
    else:productresult=product_result
    return productresult

def getImageInfo(server):
    @server.route('/gsb/api/GetHtmlInfoFromSql', methods=['POST'])
    def GetImageInfo():
        print("接口调用--------查询画像标签和产品推荐信息")
        result={}
        try:
            if request.method == 'POST':
                requestdata = request.json
                print(requestdata)
                companyname = requestdata.get('companyname')
                standard_company_name = getStandardName(companyname)
                standard_company_name1 = re_companyName.strQ2B(standard_company_name)
                Image_result = GetImageFromSql(standard_company_name1)
                product_result = GetProductFromSql(standard_company_name1)
                result = {"status":200,"msg":"操作成功","image": Image_result,"product": product_result}
        except:
            result = {"status":404,"msg":"操作失败","image": "-","product": "-"}
        return jsonify(result)




# server.run(host='127.0.0.1', port=9001, debug=True)