{
    template: '${tmpl}',
        data: function() {
            return {
                brandOptions: [{
                    value: '2019',
                    label: '2019'
                }, {
                    value: '2018',
                    label: '2018'
                }, {
                    value: '2017',
                    label: '2017'
                }, {
                    value: '2016',
                    label: '2016'
                }, {
                    value: '2015',
                    label: '2015'
                }, {
                    value: '2014',
                    label: '2014'
                }, {
                    value: '2013',
                    label: '2013'
                }, {
                    value: '2012',
                    label: '2012'
                }, {
                    value: '2011',
                    label: '2011'
                }, {
                    value: '2010',
                    label: '2010'
                }],
                brandName: '2019',
                ncldata: [
                    {}, { code: "01", name: "化学原料", type: 1 }, { code: "02", name: "颜料油漆", type: 1 }, { code: "03", name: "日化用品", type: 1 }, { code: "04", name: "燃料油脂", type: 1 }, { code: "05", name: "医药", type: 1 },
                    { code: "06", name: "金属材料", type: 1 }, { code: "07", name: "机械设备", type: 1 }, { code: "08", name: "手工器械", type: 1 }, { code: "09", name: "科学仪器", type: 1 }, { code: "10", name: "医疗器械", type: 1 },
                    { code: "11", name: "灯具空调", type: 1 }, { code: "12", name: "运输工具", type: 1 }, { code: "13", name: "军火烟火", type: 1 }, { code: "14", name: "珠宝钟表", type: 1 }, { code: "15", name: "乐器", type: 1 },
                    { code: "16", name: "办公用品", type: 1 }, { code: "17", name: "橡胶制品", type: 1 }, { code: "18", name: "皮革皮具", type: 1 }, { code: "19", name: "建筑材料", type: 1 }, { code: "20", name: "家具", type: 1 },
                    { code: "21", name: "厨房洁具", type: 1 }, { code: "22", name: "绳网袋篷", type: 1 }, { code: "23", name: "纱线丝", type: 1 }, { code: "24", name: "布料床单", type: 1 }, { code: "25", name: "服装鞋帽", type: 1 },
                    { code: "26", name: "纽扣拉链", type: 1 }, { code: "27", name: "地毯席垫", type: 1 }, { code: "28", name: "健身器材", type: 1 }, { code: "29", name: "食品", type: 1 }, { code: "30", name: "方便食品", type: 1 },
                    { code: "31", name: "饲料种籽", type: 1 }, { code: "32", name: "啤酒饮料", type: 1 }, { code: "33", name: "酒", type: 1 }, { code: "34", name: "烟草烟具", type: 1 }, { code: "35", name: "广告销售", type: 1 },
                    { code: "36", name: "金融物管", type: 1 }, { code: "37", name: "建筑修理", type: 1 }, { code: "38", name: "通讯服务", type: 1 }, { code: "39", name: "运输贮藏", type: 1 }, { code: "40", name: "材料加工", type: 1 },
                    { code: "41", name: "教育娱乐", type: 1 }, { code: "42", name: "网站服务", type: 1 }, { code: "43", name: "餐饮住宿", type: 1 }, { code: "44", name: "医疗园艺", type: 1 }, { code: "45", name: "社会服务", type: 1 }
                ],
                brandArr: [
                    {
                        name: '商标总量',
                        amount: ''
                    }, {
                        name: '商标有效注册量',
                        amount: ''
                    }, {
                        name: '商标申请次数总量',
                        amount: ''
                    }, {
                        name: '商标申请企业总量',
                        amount: ''
                    },
                ],
                brandDistrict: [],
                brandEnterprise: [],
                brandSortrow: [],
                title: '多 X 轴示例',
                tabsKey: 1,
                trademarkApplicationdata: {
                    boundaryGap: false,
                    color: ['#5793f3', '#d14a61', '#675bba'],
                    tooltip: {
                        trigger: 'axis',
                        formatter: function(params) {
                            return `<div>
                                <p>${params[0].axisValue}</p>
                                <p>${params[0].marker}${params[0].seriesName}:${params[0].value}</p>
                                <p>${params[1].marker}${params[1].seriesName}:${params[1].value}</p>
                            </div>`;  
                        },
                        axisPointer: {
                            type: 'cross'
                        },
                    },
                    title:{
                        text:"商标申请及注册趋势",
                        y:'30px',
                        textStyle:{
                            fontWeight: '500',
                            fontSize:'15px',             
                            color: '#666'
                        }
                    },
                    legend: {
                        y: '35px',
                        right:'10%',
                        data: ['商标申请', '商标注册']
                    },
                    grid: {
                        top: 70,
                        bottom: 50
                    },
                    xAxis: [
                        {
                            type: 'category',
                            boundaryGap: false,
                            axisTick: {
                                alignWithLabel: true,
                                show:false
                            },
                            axisLine: {
                                onZero: false,
                                lineStyle: {
                                    color: '#5793f3',
                                    width: 1
                                }
                            },
                            axisPointer: {
                                tooltip: {
                                    formatter: function (params) {
                                        return params;
                                    }
                                }
                            },
                            data: ["2014", "2015", "2016", "2017", "2018", "2019"],
                        },
                        
                    ],
                    yAxis: [
                        {
                            type: 'value',
                            splitNumber:4,
                            max:8000000,
                            boundaryGap: false,
                            axisTick: {
                                alignWithLabel: true,
                                show:false
                            },
                            axisLine: {
                                onZero: false,
                                lineStyle: {
                                    color: '#5793f3',
                                    width: 1
                                }
                            },
                            axisPointer: {
                                tooltip: {
                                    formatter: function (params) {
                                        return params;
                                    }
                                }
                            },
                            splitLine: {
                                show: true,
                                lineStyle:{
                                    color:'#F1F4F5',
                                    type: 'solid'
                                }
                            },
                        }
                    ],
                    series: [{
                        name: 'pv', 
                        itemStyle: {
                            normal: {
                                color: '#FEBD04',
                                lineStyle: {
                                    color: '#FEBD04',
                                    width: 2
                                },
                            }
                        },
                        smooth: true,
                        type: 'line',
                        data: [],
                        animationDuration: 2800,
                        animationEasing: 'cubicInOut'
                    },
                    {
                        name: 'ip',
                        smooth: true,
                        type: 'line',
                        itemStyle: {
                            normal: {
                                color: '#3888fa',
                                lineStyle: {
                                    color: '#3888fa',
                                    width: 2
                                },
                                areaStyle: {
                                    color: 'rgba(10, 144, 254, 0.05)'
                                }
                            }
                        },
                        data: [],
                        animationDuration: 2800,
                        animationEasing: 'quadraticOut'
                    }]
                },
                provinceType: false,
                cityType: false,
                provinceName: '',
                provinceNameOne: '',
                regionEchartdata: {
                    tooltip: {
                        trigger: 'item'
                    },
                    dataRange: {
                        orient: 'vertical',
                        min: 0,
                        max: 700000,
                        text: ['High', 'Low'],
                        textStyle: {
                            color: "#ffffff"
                        },
                        splitNumber: 0,
                        color: ['rgb(3,112,222)', 'rgb(100,175,236)', 'rgb(222,254,255)']
                    },
                    series: [{
                        name: '商标数量',
                        type: 'map',
                        mapType: 'china',
                        mapLocation: {
                            x: 'left'
                        },
                        selectedMode: 'multiple',
                        itemStyle: {
                            normal: { label: { show: true } },
                            emphasis: {
                                label: { show: true },
                                areaStyle: { color: "" }
                            }
                        },
                        data: [

                        ]
                    }]
                },
                myChart: "",
                city: "",
                provinces: [
                    'shanghai', 'hebei', 'shanxi', 'neimenggu', 'liaoning', 'jilin', 'heilongjiang', 'jiangsu', 'zhejiang', 'anhui', 'fujian',
                    'jiangxi', 'shandong', 'henan', 'hubei', 'hunan', 'guangdong', 'guangxi', 'hainan', 'sichuan', 'guizhou', 'yunnan', 'xizang',
                    'shanxi1', 'gansu', 'qinghai', 'ningxia', 'xinjiang', 'beijing', 'tianjin', 'chongqing', 'xianggang', 'aomen', 'taiwan'
                ],
                provincesText: [
                    '上海', '河北', '山西', '内蒙古', '辽宁', '吉林', '黑龙江', '江苏', '浙江', '安徽', '福建', '江西', '山东', '河南', '湖北',
                    '湖南', '广东', '广西', '海南', '四川', '贵州', '云南', '西藏', '陕西', '甘肃', '青海', '宁夏', '新疆', '北京', '天津',
                    '重庆', '香港', '澳门', '台湾'
                ],
                Beijing: ['密云区', '延庆区', '朝阳区', '丰台区', '石景山区', '海淀区', '门头沟区', '房山区', '通州区', '顺义区', '昌平区', '大兴区', '怀柔区', '平谷区', '东城区', '西城区'],
                cityMap: [
                    { name: "安徽", value: "340000" },
                    { name: "澳门", value: '820000' },
                    { name: "北京", value: '110000' },
                    { name: "重庆", value: '500000' },
                    { name: "福建", value: '350000' },
                    { name: "甘肃", value: '620000' },
                    { name: "广东", value: '440000' },
                    { name: "广西", value: "450000" },
                    { name: "贵州", value: '520000' },
                    { name: "海南", value: '460000' },
                    { name: "河北", value: '130000' },
                    { name: "黑龙江", value: '230000' },
                    { name: "河南", value: '410000' },
                    { name: "湖北", value: '420000' },
                    { name: "湖南", value: '430000' },
                    { name: "江苏", value: '320000' },
                    { name: "江西", value: '360000' },
                    { name: "吉林", value: '220000' },
                    { name: "辽宁", value: '210000' },
                    { name: "内蒙古", value: '150000' },
                    { name: "宁夏", value: '640000' },
                    { name: "青海", value: '630000' },
                    { name: "山东", value: '370000' },
                    { name: "上海", value: '310000' },
                    { name: "山西", value: '140000' },
                    { name: "四川", value: '510000' },
                    { name: "台湾", value: '710000' },
                    { name: "天津", value: '120000' },
                    { name: "新疆", value: '650000' },
                    { name: "陕西", value: '610000' },
                    { name: "西藏", value: '540000' },
                    { name: "云南", value: '530000' },
                    { name: "浙江", value: '330000' },
                    { name: "香港", value: '810000' },
                    { name: "北京市", value: "110100" },
                    { name: "天津市", value: "120100" },
                    { name: "上海市", value: "310100" },
                    { name: "重庆市", value: "500100" },
                    { name: "崇明县", value: "310200" },
                    { name: "湖北省直辖县市", value: "429000" },
                    { name: "铜仁市", value: "522200" },
                    { name: "毕节市", value: "522400" },
                    { name: "石家庄市", value: "130100" },
                    { name: "唐山市", value: "130200" },
                    { name: "秦皇岛市", value: "130300" },
                    { name: "邯郸市", value: "130400" },
                    { name: "邢台市", value: "130500" },
                    { name: "保定市", value: "130600" },
                    { name: "张家口市", value: "130700" },
                    { name: "承德市", value: "130800" },
                    { name: "沧州市", value: "130900" },
                    { name: "廊坊市", value: "131000" },
                    { name: "衡水市", value: "131100" },
                    { name: "太原市", value: "140100" },
                    { name: "大同市", value: "140200" },
                    { name: "阳泉市", value: "140300" },
                    { name: "长治市", value: "140400" },
                    { name: "晋城市", value: "140500" },
                    { name: "朔州市", value: "140600" },
                    { name: "晋中市", value: "140700" },
                    { name: "运城市", value: "140800" },
                    { name: "忻州市", value: "140900" },
                    { name: "临汾市", value: "141000" },
                    { name: "吕梁市", value: "141100" },
                    { name: "呼和浩特市", value: "150100" },
                    { name: "包头市", value: "150200" },
                    { name: "乌海市", value: "150300" },
                    { name: "赤峰市", value: "150400" },
                    { name: "通辽市", value: "150500" },
                    { name: "鄂尔多斯市", value: "150600" },
                    { name: "呼伦贝尔市", value: "150700" },
                    { name: "巴彦淖尔市", value: "150800" },
                    { name: "乌兰察布市", value: "150900" },
                    { name: "兴安盟", value: "152200" },
                    { name: "锡林郭勒盟", value: "152500" },
                    { name: "阿拉善盟", value: "152900" },
                    { name: "沈阳市", value: "210100" },
                    { name: "大连市", value: "210200" },
                    { name: "鞍山市", value: "210300" },
                    { name: "抚顺市", value: "210400" },
                    { name: "本溪市", value: "210500" },
                    { name: "丹东市", value: "210600" },
                    { name: "锦州市", value: "210700" },
                    { name: "营口市", value: "210800" },
                    { name: "阜新市", value: "210900" },
                    { name: "辽阳市", value: "211000" },
                    { name: "盘锦市", value: "211100" },
                    { name: "铁岭市", value: "211200" },
                    { name: "朝阳市", value: "211300" },
                    { name: "葫芦岛市", value: "211400" },
                    { name: "长春市", value: "220100" },
                    { name: "吉林市", value: "220200" },
                    { name: "四平市", value: "220300" },
                    { name: "辽源市", value: "220400" },
                    { name: "通化市", value: "220500" },
                    { name: "白山市", value: "220600" },
                    { name: "松原市", value: "220700" },
                    { name: "白城市", value: "220800" },
                    { name: "延边朝鲜族自治州", value: "222400" },
                    { name: "哈尔滨市", value: "230100" },
                    { name: "齐齐哈尔市", value: "230200" },
                    { name: "鸡西市", value: "230300" },
                    { name: "鹤岗市", value: "230400" },
                    { name: "双鸭山市", value: "230500" },
                    { name: "大庆市", value: "230600" },
                    { name: "伊春市", value: "230700" },
                    { name: "佳木斯市", value: "230800" },
                    { name: "七台河市", value: "230900" },
                    { name: "牡丹江市", value: "231000" },
                    { name: "黑河市", value: "231100" },
                    { name: "绥化市", value: "231200" },
                    { name: "大兴安岭地区", value: "232700" },
                    { name: "南京市", value: "320100" },
                    { name: "无锡市", value: "320200" },
                    { name: "徐州市", value: "320300" },
                    { name: "常州市", value: "320400" },
                    { name: "苏州市", value: "320500" },
                    { name: "南通市", value: "320600" },
                    { name: "连云港市", value: "320700" },
                    { name: "淮安市", value: "320800" },
                    { name: "盐城市", value: "320900" },
                    { name: "扬州市", value: "321000" },
                    { name: "镇江市", value: "321100" },
                    { name: "泰州市", value: "321200" },
                    { name: "宿迁市", value: "321300" },
                    { name: "杭州市", value: "330100" },
                    { name: "宁波市", value: "330200" },
                    { name: "温州市", value: "330300" },
                    { name: "嘉兴市", value: "330400" },
                    { name: "湖州市", value: "330500" },
                    { name: "绍兴市", value: "330600" },
                    { name: "金华市", value: "330700" },
                    { name: "衢州市", value: "330800" },
                    { name: "舟山市", value: "330900" },
                    { name: "台州市", value: "331000" },
                    { name: "丽水市", value: "331100" },
                    { name: "合肥市", value: "340100" },
                    { name: "芜湖市", value: "340200" },
                    { name: "蚌埠市", value: "340300" },
                    { name: "淮南市", value: "340400" },
                    { name: "马鞍山市", value: "340500" },
                    { name: "淮北市", value: "340600" },
                    { name: "铜陵市", value: "340700" },
                    { name: "安庆市", value: "340800" },
                    { name: "黄山市", value: "341000" },
                    { name: "滁州市", value: "341100" },
                    { name: "阜阳市", value: "341200" },
                    { name: "宿州市", value: "341300" },
                    { name: "六安市", value: "341500" },
                    { name: "亳州市", value: "341600" },
                    { name: "池州市", value: "341700" },
                    { name: "宣城市", value: "341800" },
                    { name: "福州市", value: "350100" },
                    { name: "厦门市", value: "350200" },
                    { name: "莆田市", value: "350300" },
                    { name: "三明市", value: "350400" },
                    { name: "泉州市", value: "350500" },
                    { name: "漳州市", value: "350600" },
                    { name: "南平市", value: "350700" },
                    { name: "龙岩市", value: "350800" },
                    { name: "宁德市", value: "350900" },
                    { name: "南昌市", value: "360100" },
                    { name: "景德镇市", value: "360200" },
                    { name: "萍乡市", value: "360300" },
                    { name: "九江市", value: "360400" },
                    { name: "新余市", value: "360500" },
                    { name: "鹰潭市", value: "360600" },
                    { name: "赣州市", value: "360700" },
                    { name: "吉安市", value: "360800" },
                    { name: "宜春市", value: "360900" },
                    { name: "抚州市", value: "361000" },
                    { name: "上饶市", value: "361100" },
                    { name: "济南市", value: "370100" },
                    { name: "青岛市", value: "370200" },
                    { name: "淄博市", value: "370300" },
                    { name: "枣庄市", value: "370400" },
                    { name: "东营市", value: "370500" },
                    { name: "烟台市", value: "370600" },
                    { name: "潍坊市", value: "370700" },
                    { name: "济宁市", value: "370800" },
                    { name: "泰安市", value: "370900" },
                    { name: "威海市", value: "371000" },
                    { name: "日照市", value: "371100" },
                    { name: "莱芜市", value: "371200" },
                    { name: "临沂市", value: "371300" },
                    { name: "德州市", value: "371400" },
                    { name: "聊城市", value: "371500" },
                    { name: "滨州市", value: "371600" },
                    { name: "菏泽市", value: "371700" },
                    { name: "郑州市", value: "410100" },
                    { name: "开封市", value: "410200" },
                    { name: "洛阳市", value: "410300" },
                    { name: "平顶山市", value: "410400" },
                    { name: "安阳市", value: "410500" },
                    { name: "鹤壁市", value: "410600" },
                    { name: "新乡市", value: "410700" },
                    { name: "焦作市", value: "410800" },
                    { name: "濮阳市", value: "410900" },
                    { name: "许昌市", value: "411000" },
                    { name: "漯河市", value: "411100" },
                    { name: "三门峡市", value: "411200" },
                    { name: "南阳市", value: "411300" },
                    { name: "商丘市", value: "411400" },
                    { name: "信阳市", value: "411500" },
                    { name: "周口市", value: "411600" },
                    { name: "驻马店市", value: "411700" },
                    { name: "省直辖县级行政区划", value: "469000" },
                    { name: "武汉市", value: "420100" },
                    { name: "黄石市", value: "420200" },
                    { name: "十堰市", value: "420300" },
                    { name: "宜昌市", value: "420500" },
                    { name: "襄阳市", value: "420600" },
                    { name: "鄂州市", value: "420700" },
                    { name: "荆门市", value: "420800" },
                    { name: "孝感市", value: "420900" },
                    { name: "荆州市", value: "421000" },
                    { name: "黄冈市", value: "421100" },
                    { name: "咸宁市", value: "421200" },
                    { name: "随州市", value: "421300" },
                    { name: "恩施土家族苗族自治州", value: "422800" },
                    { name: "长沙市", value: "430100" },
                    { name: "株洲市", value: "430200" },
                    { name: "湘潭市", value: "430300" },
                    { name: "衡阳市", value: "430400" },
                    { name: "邵阳市", value: "430500" },
                    { name: "岳阳市", value: "430600" },
                    { name: "常德市", value: "430700" },
                    { name: "张家界市", value: "430800" },
                    { name: "益阳市", value: "430900" },
                    { name: "郴州市", value: "431000" },
                    { name: "永州市", value: "431100" },
                    { name: "怀化市", value: "431200" },
                    { name: "娄底市", value: "431300" },
                    { name: "湘西土家族苗族自治州", value: "433100" },
                    { name: "广州市", value: "440100" },
                    { name: "韶关市", value: "440200" },
                    { name: "深圳市", value: "440300" },
                    { name: "珠海市", value: "440400" },
                    { name: "汕头市", value: "440500" },
                    { name: "佛山市", value: "440600" },
                    { name: "江门市", value: "440700" },
                    { name: "湛江市", value: "440800" },
                    { name: "茂名市", value: "440900" },
                    { name: "肇庆市", value: "441200" },
                    { name: "惠州市", value: "441300" },
                    { name: "梅州市", value: "441400" },
                    { name: "汕尾市", value: "441500" },
                    { name: "河源市", value: "441600" },
                    { name: "阳江市", value: "441700" },
                    { name: "清远市", value: "441800" },
                    { name: "东莞市", value: "441900" },
                    { name: "中山市", value: "442000" },
                    { name: "潮州市", value: "445100" },
                    { name: "揭阳市", value: "445200" },
                    { name: "云浮市", value: "445300" },
                    { name: "南宁市", value: "450100" },
                    { name: "柳州市", value: "450200" },
                    { name: "桂林市", value: "450300" },
                    { name: "梧州市", value: "450400" },
                    { name: "北海市", value: "450500" },
                    { name: "防城港市", value: "450600" },
                    { name: "钦州市", value: "450700" },
                    { name: "贵港市", value: "450800" },
                    { name: "玉林市", value: "450900" },
                    { name: "百色市", value: "451000" },
                    { name: "贺州市", value: "451100" },
                    { name: "河池市", value: "451200" },
                    { name: "来宾市", value: "451300" },
                    { name: "崇左市", value: "451400" },
                    { name: "海口市", value: "460100" },
                    { name: "三亚市", value: "460200" },
                    { name: "三沙市", value: "460300" },
                    { name: "成都市", value: "510100" },
                    { name: "自贡市", value: "510300" },
                    { name: "攀枝花市", value: "510400" },
                    { name: "泸州市", value: "510500" },
                    { name: "德阳市", value: "510600" },
                    { name: "绵阳市", value: "510700" },
                    { name: "广元市", value: "510800" },
                    { name: "遂宁市", value: "510900" },
                    { name: "内江市", value: "511000" },
                    { name: "乐山市", value: "511100" },
                    { name: "南充市", value: "511300" },
                    { name: "眉山市", value: "511400" },
                    { name: "宜宾市", value: "511500" },
                    { name: "广安市", value: "511600" },
                    { name: "达州市", value: "511700" },
                    { name: "雅安市", value: "511800" },
                    { name: "巴中市", value: "511900" },
                    { name: "资阳市", value: "512000" },
                    { name: "阿坝藏族羌族自治州", value: "513200" },
                    { name: "甘孜藏族自治州", value: "513300" },
                    { name: "凉山彝族自治州", value: "513400" },
                    { name: "贵阳市", value: "520100" },
                    { name: "六盘水市", value: "520200" },
                    { name: "遵义市", value: "520300" },
                    { name: "安顺市", value: "520400" },
                    { name: "黔西南布依族苗族自治州", value: "522300" },
                    { name: "黔东南苗族侗族自治州", value: "522600" },
                    { name: "黔南布依族苗族自治州", value: "522700" },
                    { name: "昆明市", value: "530100" },
                    { name: "曲靖市", value: "530300" },
                    { name: "玉溪市", value: "530400" },
                    { name: "保山市", value: "530500" },
                    { name: "昭通市", value: "530600" },
                    { name: "丽江市", value: "530700" },
                    { name: "普洱市", value: "530800" },
                    { name: "临沧市", value: "530900" },
                    { name: "楚雄彝族自治州", value: "532300" },
                    { name: "红河哈尼族彝族自治州", value: "532500" },
                    { name: "文山壮族苗族自治州", value: "532600" },
                    { name: "西双版纳傣族自治州", value: "532800" },
                    { name: "大理白族自治州", value: "532900" },
                    { name: "德宏傣族景颇族自治州", value: "533100" },
                    { name: "怒江傈僳族自治州", value: "533300" },
                    { name: "迪庆藏族自治州", value: "533400" },
                    { name: "拉萨市", value: "540100" },
                    { name: "昌都地区", value: "542100" },
                    { name: "山南地区", value: "542200" },
                    { name: "日喀则地区", value: "542300" },
                    { name: "那曲地区", value: "542400" },
                    { name: "阿里地区", value: "542500" },
                    { name: "林芝地区", value: "542600" },
                    { name: "西安市", value: "610100" },
                    { name: "铜川市", value: "610200" },
                    { name: "宝鸡市", value: "610300" },
                    { name: "咸阳市", value: "610400" },
                    { name: "渭南市", value: "610500" },
                    { name: "延安市", value: "610600" },
                    { name: "汉中市", value: "610700" },
                    { name: "榆林市", value: "610800" },
                    { name: "安康市", value: "610900" },
                    { name: "商洛市", value: "611000" },
                    { name: "兰州市", value: "620100" },
                    { name: "嘉峪关市", value: "620200" },
                    { name: "金昌市", value: "620300" },
                    { name: "白银市", value: "620400" },
                    { name: "天水市", value: "620500" },
                    { name: "武威市", value: "620600" },
                    { name: "张掖市", value: "620700" },
                    { name: "平凉市", value: "620800" },
                    { name: "酒泉市", value: "620900" },
                    { name: "庆阳市", value: "621000" },
                    { name: "定西市", value: "621100" },
                    { name: "陇南市", value: "621200" },
                    { name: "临夏回族自治州", value: "622900" },
                    { name: "甘南藏族自治州", value: "623000" },
                    { name: "西宁市", value: "630100" },
                    { name: "海东地区", value: "632100" },
                    { name: "海北藏族自治州", value: "632200" },
                    { name: "黄南藏族自治州", value: "632300" },
                    { name: "海南藏族自治州", value: "632500" },
                    { name: "果洛藏族自治州", value: "632600" },
                    { name: "玉树藏族自治州", value: "632700" },
                    { name: "海西蒙古族藏族自治州", value: "632800" },
                    { name: "银川市", value: "640100" },
                    { name: "石嘴山市", value: "640200" },
                    { name: "吴忠市", value: "640300" },
                    { name: "固原市", value: "640400" },
                    { name: "中卫市", value: "640500" },
                    { name: "乌鲁木齐市", value: "650100" },
                    { name: "克拉玛依市", value: "650200" },
                    { name: "吐鲁番地区", value: "652100" },
                    { name: "哈密地区", value: "652200" },
                    { name: "昌吉回族自治州", value: "652300" },
                    { name: "博尔塔拉蒙古自治州", value: "652700" },
                    { name: "巴音郭楞蒙古自治州", value: "652800" },
                    { name: "阿克苏地区", value: "652900" },
                    { name: "克孜勒苏柯尔克孜自治州", value: "653000" },
                    { name: "喀什地区", value: "653100" },
                    { name: "和田地区", value: "653200" },
                    { name: "伊犁哈萨克自治州", value: "654000" },
                    { name: "塔城地区", value: "654200" },
                    { name: "阿勒泰地区", value: "654300" },
                    { name: "自治区直辖县级行政区划", value: "659000" },
                    { name: "台湾省", value: "710000" },
                    { name: "香港特别行政区", value: "810100" },
                    { name: "澳门特别行政区", value: "820000" }
                ],
                cityEchartdata: {
                    tooltip: {
                        trigger: 'item'
                    },
                    dataRange: {
                        orient: 'vertical',
                        min: 0,
                        max: 700000,
                        text: ['High', 'Low'],
                        textStyle: {
                            color: "#ffffff"
                        },
                        splitNumber: 0,
                        color: ['rgb(3,112,222)', 'rgb(100,175,236)', 'rgb(222,254,255)']
                    },
                    series: [{
                        name: '商标数量',
                        type: 'map',
                        mapType: '',
                        mapLocation: {
                            x: 'left'
                        },
                        itemStyle: {
                            normal: { label: { show: true } },
                            emphasis: { label: { show: true } }
                        },
                        data: [

                        ]
                    }]

                },
                loading:false,
            }
        },

    methods: {
        brandEve(val) {
            console.log(val);
            this.tmindexdetailPost()
        },
        tmindexdetailPost() {
            var obj =
            {
                year: this.brandName,
                apply_addr_province: this.provinceName
            };
            this.tmstatistics(obj);
            this.tmcompanystatistics(obj);
            this.tmaddrstatisticsrank(obj);
            this.tmcompanystatisticsrank(obj);
            this.tmnclstatisticsrank(obj);

            /** var that = this;
            this.loading = true;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmindexdetail", obj).then(d=>{
                this.loading = false;
                console.log(d,'********************************');
                that.brandArr[0].amount = d.data.tmtotal;
                that.brandArr[1].amount = d.data.tmzctotal;
                that.brandArr[2].amount = d.data.tmsqtotal;
                that.brandArr[3].amount = d.data.tmgstotal;
                that.brandDistrict = d.data.tmaddrrank;
                that.brandEnterprise = d.data.tmcompanyrank;
                that.brandSortrow = d.data.tmnclrank;
                that.myChart = echarts.init(document.getElementById('container'));
                var this_ = that;
                if (that.provinceName == '') {
                    that.regionEchartdata.series[0].data = d.data.maplist;
                    that.myChart.setOption(that.regionEchartdata,true);
                    window.addEventListener("resize",function(){
                        this_.myChart.resize();
                    });
                    that.$forceUpdate();
                }else {
                    that.cityEchartdata.dataRange.max = d.data.tmaddrrank[0].areacount;
                    that.cityEchartdata.series[0].mapType = that.provinceName;
                    that.cityEchartdata.series[0].data = d.data.maplist;
                    that.myChart.setOption(this.cityEchartdata, true);
                    window.addEventListener("resize",function(){
                        this_.myChart.resize();
                    });
                    that.$forceUpdate();
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });*/
        },
        /**商标统计接口总量、有效、申请 */
        tmstatistics(obj){
            var that = this;
            this.loading = true;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmstatistics", obj).then(d => {
                this.loading = false;
                if (d && d.status == 0 && d.data) {
                    that.brandArr[0].amount = d.data.tmtotal;
                    that.brandArr[1].amount = d.data.tmzctotal;
                    that.brandArr[2].amount = d.data.tmsqtotal;
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**商标统计接口公司总量 */
        tmcompanystatistics(obj){
            var that = this;
            this.loading = true;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmcompanystatistics", obj).then(d => {
                this.loading = false;
                if (d && d.status == 0 && d.data) {
                    that.brandArr[3].amount = d.data.tmgstotal;
                }

            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**商标地区分布统计排名 */
        tmaddrstatisticsrank(obj){
            var that = this;
            this.loading = true;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmaddrstatisticsrank", obj).then(d => {
                this.loading = false;
                if (d && d.status == 0 && d.data) {
                    that.brandDistrict = d.data.tmaddrrank;
                    if (that.provinceName == '') {
                        that.regionEchartdata.series[0].data = d.data.maplist;
                        that.myChart.setOption(that.regionEchartdata, true);
                        window.addEventListener("resize", function () {
                            that.myChart.resize();
                        });
                        that.$forceUpdate();
                    } else {
                        that.cityEchartdata.dataRange.max = d.data.tmaddrrank[0].areacount;
                        that.cityEchartdata.series[0].mapType = that.provinceName;
                        that.cityEchartdata.series[0].data = d.data.maplist;
                        that.myChart.setOption(this.cityEchartdata, true);
                        window.addEventListener("resize", function () {
                            that.myChart.resize();
                        });
                        that.$forceUpdate();
                    }
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**商标企业分布统计排名 */
        tmcompanystatisticsrank(obj){
            var that = this;
            this.loading = true;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmcompanystatisticsrank", obj).then(d => {
                this.loading = false;
                if (d && d.status == 0 && d.data) {
                    that.brandEnterprise = d.data.tmcompanyrank;
                }

            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**商标类别申请排名 */
        tmnclstatisticsrank(obj){
            var that = this;
            this.loading = true;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmnclstatisticsrank", obj).then(d => {
                this.loading = false;
                if (d && d.status == 0 && d.data) {
                    that.brandSortrow = d.data.tmnclrank;
                }

            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        tmtrendPost(name) {
            var obj =
            {
                apply_addr_province: name
            };
            var that = this;
            this.$root.postReq("/web/tmquery/bigtmCtl/tmtrend", obj).then(function (d) {
                console.log(d, '#######################################');
                var data = d.data;
                var echarts = that.$refs.trademarkApplicationRef.getEchartObj();
                that.trademarkApplicationdata.series[0].data = data.sqtrend.data;
                that.trademarkApplicationdata.series[1].data = data.zctrend.data;
                that.trademarkApplicationdata.series[0].name = data.sqtrend.name;
                that.trademarkApplicationdata.series[1].name = data.zctrend.name;
                echarts.setOption(that.trademarkApplicationdata);
                window.addEventListener("resize", function () {
                    echarts.resize();
                });
                that.$forceUpdate();
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        tmbigdatadetail(val) {
            console.log('跳转详情页', val);
            this.$router.push({ path: '/tmbigdatadetail', query: { toponymy: this.provinceNameOne, num: val, year: this.brandName } })
        },
        returnpage(val) {
            console.log("val");
            console.log(val);
            if (val == 1) {
                console.log(this.provinceNameOne);
                console.log(this.provincesText);
                window.localStorage.setItem("provinceName", this.provinceNameOne);
                var that = this;
                for (var i = 0; i < that.provincesText.length; i++) {
                    if (this.provinceNameOne == that.provincesText[i]) {
                        that.showProvince(that.provinces[i], that.provincesText[i]);
                        break;
                    }
                }
            } else {
                this.myChart.setOption(this.regionEchartdata, true);
                this.provinceType = false;
                this.provinceName = '';
                this.tmindexdetailPost();
                this.tmtrendPost();
            }

        },
        showProvince(pName, Chinese_){
            ;
            console.log(pName, Chinese_);
            this.provinceNameOne = Chinese_ || this.provinceNameOne;
            this.cityEchartdata.series[0].mapType = '';
            this.provinceName = Chinese_;
            this.provinceType = true;
            var that = this;
            console.log('$' + pName + 'JS', 'js/echarts/province/' + pName + '.js');
            this.loadBdScript('$' + pName + 'JS', 'js/echarts/province/' + pName + '.js', function () {
                that.tmtrendPost();
                that.tmindexdetailPost();
            });

        },
        loadBdScript(scriptId, url, callback){
            var script = document.createElement("script");

            script.type = "text/javascript";
            if (script.readyState) {
                console.log(1);
                script.onreadystatechange = function () {
                    if (script.readyState == "loaded" || script.readyState == "complete") {
                        script.onreadystatechange = null;
                        callback();
                    }
                };

            } else {
                console.log(2);
                script.onload = function () {
                    callback();
                };
            }
            script.src = url;
            script.id = scriptId;

            document.getElementsByTagName("head")[0].appendChild(script);
        }
    },
    mounted: function() {
        var that = this;
        this.tmindexdetailPost();
        this.tmtrendPost();
        this.$nextTick(() => {
            this.myChart = echarts.init(document.getElementById('container'));
            this.myChart.setOption(this.regionEchartdata, true);
            this.myChart.on('click', function (params) {
                console.log(params);
                that.city = params.name;
                for (var i = 0; i < that.provincesText.length; i++) {
                    if (params.name == that.provincesText[i]) {
                        that.showProvince(that.provinces[i], that.provincesText[i]);
                        break;
                    }
                }
            });
        });


    },
    vname: "gsb-tmbigdata"
}
