{
  template: '${tmpl}',
    data: function() {
      return {
        regNum: "",
        nclNum: "",
        tmdetail: {},
        serviceitems: [],
        serviceitems_wzc: [],
        loading:false,
        regNum2:null,
        nclNum2:null,
      }
    },

  methods: {
    getTmDetail(){ 
      if (!this.regNum) {
        this.$message.warning("参数错误");
        return;
      }
      if (!this.nclNum) {
        this.$message.warning("参数错误");
        return;
      }
      var obj = {
        "sbzch": this.regNum,
        "gjfl": this.nclNum
      };
      this.loading = true;
      this.$root.postReq("/web/tmquery/tmqueryCtl/tradeMarkDetail", obj).then(d => {
        this.loading = false;
        if (d && d.status == 0 && d.data) {
          if (d.data.detaildata && d.data.detaildata.length > 0) {
            this.tmdetail = JSON.parse(JSON.stringify(d.data.detaildata[0]));
            if (this.tmdetail && this.tmdetail.sbzt) {
              if (this.tmdetail.sbzt == "申请中") {
                this.tmdetail["active"] = 1;
              } else if (this.tmdetail.sbzt == "已初审") {
                this.tmdetail["active"] = 2;
              } else if (this.tmdetail.sbzt == "已注册") {
                this.tmdetail["active"] = 3;
                if (this.tmdetail.jzrq) {
                  var datea = new Date(this.tmdetail.jzrq);
                  var dateb = new Date();
                  if (datea <= dateb) {
                    this.tmdetail["active"] = 4;
                  }
                }
              }
            }
          }
          if (d.data.nclexist && d.data.nclexist.length > 0) {
            this.serviceitems = d.data.nclexist;
          }
          if (d.data.nclnotexist && d.data.nclnotexist.length > 0) {
            this.serviceitems_wzc = d.data.nclnotexist;
          }

        }
      }).catch(function (e) {
        that.loading = false;
        that.$message.warning(`操作失败，请刷新页面后重新操作`);
      });
    },
    toproposer(company_name){
      if (company_name) {
        this.$router.push({ path: '/proposer', query: { company_name: company_name } });
      }
    }
  },
  mounted: function() {
    this.regNum = this.$router.history.current.query.regNum || "";
    this.nclNum = this.$router.history.current.query.nclNum || "";
    this.getTmDetail();

    this.$nextTick(() => {
      var box = document.getElementsByClassName('brandfinddetails-details-box-reg');
      setTimeout(() => {
        for (let i = 0; i < box.length; i++) {
          var height = box[i].offsetHeight;
          if (height != 120){
            box[i].children[0].style.height = `${height}px`;
          }
        };
      }, 600);

    });
  },
  activated:function(){
    var embedwarpper = document.getElementsByClassName("el-scrollbar__wrap")[0];
    embedwarpper.scrollTop=0;
    this.regNum = this.$router.history.current.query.regNum || "";
    this.nclNum = this.$router.history.current.query.nclNum || "";
    if(this.regNum!=this.regNum2&&this.nclNum!=this.nclNum2){
      this.getTmDetail();
      this.tmdetail.logo="";
    }
    this.regNum2 = this.$router.history.current.query.regNum || "";
    this.nclNum2 = this.$router.history.current.query.nclNum || "";
  },
  vname: "gsb-brandfinddetails"
}
