{
    template: '${tmpl}',
        data: function() {
            return {
                text: '',
                /*商标状态 */
                statusIcon: ['el-icon-circle-check', 'el-icon-circle-close', 'el-icon-time'],
                statusColor: ['statusreg', "statusinvalid", "statustrial",],
                /* 0:相同商标,1：相似商标,2：申请号,3：申请人,4：图像*/
                tabsName: "0",
                /*搜索框禁用 */
                searchDisabled: false,
                placeholder: '请输入商标名称、申请号、申请人等',
                loading:false,
                tmList: [],
                tmRegistNumsAll: [],
                pagesize: "10",
                currentpage: "1",
                total: 0,
                ncl_list: [],
                selected_ncl_list: ['不限'],
                legal_status_list: [],
                selected_legal_status_list: ['不限'],
                apply_year_list: [],
                selected_apply_year_list: ['不限'],
                checkboxLabelHigh: [],
                selected_checkboxLabelHigh: ['不限'],
                option: {
                    img: "",
                    size: 1,
                    full: false,
                    outputType: "png",
                    canMove: true,
                    fixedBox: false,
                    fixed: true,
                    original: false,
                    canMoveBox: true,
                    autoCropWidth: "",
                    autoCropHeight: "",
                    autoCrop: true,
                    centerBox: true,
                    high: true
                },
                imageUrl: "",
                imageText: "",
                tag: { name: '', type: '' },
                showcropper: false,
                title: "",
                collapseFlag: false,
                collapse: {
                    text: '更多',
                    icon: 'el-icon-arrow-down',
                    collapse: ""
                },
                collapseFlag1: false,
                collapse1: {
                    text: '更多',
                    icon: 'el-icon-arrow-down',
                    collapse: ""
                },
                collapseFlag2: false,
                collapse2: {
                    text: '更多',
                    icon: 'el-icon-arrow-down',
                    collapse: ""
                },
                province_counts_o: [],
                province_counts_t: [],
                ncl_counts_o: [],
                ncl_counts_t: [],
                timer: null,
            }
        },
    mounted: function() {
    },
    created: function() {
    },
    watch: {
        tabsName(n){
            if (n == 4) {
                this.searchDisabled = true;
                this.placeholder = "";
            } else {
                this.searchDisabled = false;
                this.placeholder = '请输入商标名称、申请号、申请人等';
            }
        }
    },
    methods: {
        addheight(){
            this.collapseFlag = !this.collapseFlag;
            if (this.collapseFlag) {
                this.collapse.collapse = 'collapse';
                this.collapse.text = "收起";
                this.collapse.icon = "el-icon-arrow-up";
            } else {
                this.collapse.collapse = '';
                this.collapse.text = "更多";
                this.collapse.icon = "el-icon-arrow-down";
            }
        },
        addheight1(){
            this.collapseFlag1 = !this.collapseFlag1;
            if (this.collapseFlag1) {
                this.collapse1.collapse = 'collapse';
                this.collapse1.text = "收起";
                this.collapse1.icon = "el-icon-arrow-up";
            } else {
                this.collapse1.collapse = '';
                this.collapse1.text = "更多";
                this.collapse1.icon = "el-icon-arrow-down";
            }
        },
        addheight2(){
            this.collapseFlag2 = !this.collapseFlag2;
            if (this.collapseFlag2) {
                this.collapse2.collapse = 'collapse';
                this.collapse2.text = "收起";
                this.collapse2.icon = "el-icon-arrow-up";
            } else {
                this.collapse2.collapse = '';
                this.collapse2.text = "更多";
                this.collapse2.icon = "el-icon-arrow-down";
            }
        },
        push(){
            this.$router.push({ path: '/ncldetail' });
        },
        /** 智能查询按钮点击事件 */
        tmSearchButtonClick(){
            if (!this.text) {
                this.$message({
                    dangerouslyUseHTMLString: true,
                    iconClass: "el-icon-warning",
                    type: 'warning',
                    message: '<strong>&nbsp;&nbsp;&nbsp;请输入搜索内容</strong>'
                });
            } else {
                this.ncl_list = [];
                this.selected_ncl_list = ["不限"];
                this.legal_status_list = [];
                this.selected_legal_status_list = ["不限"];
                this.apply_year_list = [];
                this.selected_apply_year_list = ["不限"];
                this.checkboxLabelHigh = [];
                /**"近似", "变字", "拼音", "同义词", "形近字", "换序", "包含该商标" */
                this.selected_checkboxLabelHigh = ["不限"];
                this.tmSearch();
                this.findTrademarkName(this.tabsName);
            }
        },
        /**商标检索 */
        tmSearch(){
            if (!this.text && this.tabsName != "4") {
                this.$message.warning("请输入目标");
            } else {
                /* 0:相同商标,1：相似商标,2：申请号,3：申请人,4：图像*/
                console.log(this.tabsName,"12312312");
                if (this.tabsName == "0") {
                    this.accurateTmSearch();
                } else if (this.tabsName == "1") {
                    this.similarTmSearch();
                } else if (this.tabsName == "2") {
                    this.regNumTmSearch();
                } else if (this.tabsName == "3") {
                    this.applierTmSearch();
                } else if (this.tabsName == "4") {
                    this.imageTmsearch();
                }
            }
        },
        /**精确商标查询 */
        accurateTmSearch(){
            if (!this.text) {
                this.$message.warning("请输入商标名称");
                return;
            }
            var obj = {
                "tmName": this.text, pageSize: this.pagesize, currentPage: this.currentpage,
                sqlbtabkey: [], xcl: [], ncl: [], nclNum: []
            };
            /*    "sqlbtabkey": "选中的申请类别",
                  "flzttabkey": "选中的商标状态",
                  "sqnftabkey": "选中的商标申请年份",
                  "ncl": ["首页选中的商标大类"],
                  "xcl": ["选中的商标大类下的群组"],
                  "nclNum": ["选中进入搜索页面商标大类"],
            };*/
            if (this.selected_ncl_list && this.selected_ncl_list.length > 0) {
                var selected_ncl_list = [];
                Object.assign(selected_ncl_list, this.selected_ncl_list);
                var index = selected_ncl_list.indexOf("不限");
                if (index >= 0) {
                    selected_ncl_list.splice(index, 1);
                }
                obj["nclNum"] = selected_ncl_list;
                obj["ncl"] = selected_ncl_list;
                obj["sqlbtabkey"] = selected_ncl_list;
            }
            if (this.selected_apply_year_list && this.selected_apply_year_list.length > 0) {
                var selected_apply_year_list = [];
                Object.assign(selected_apply_year_list, this.selected_apply_year_list);
                var index = selected_apply_year_list.indexOf("不限");
                if (index >= 0) {
                    selected_apply_year_list.splice(index, 1);
                }
                obj["sqnftabkey"] = selected_apply_year_list;
            }
            if (this.selected_legal_status_list && this.selected_legal_status_list.length > 0) {
                var selected_legal_status_list = [];
                Object.assign(selected_legal_status_list, this.selected_legal_status_list);
                var index = selected_legal_status_list.indexOf("不限");
                if (index >= 0) {
                    selected_legal_status_list.splice(index, 1);
                }
                obj["flzttabkey"] = selected_legal_status_list;
            }
            this.loading = true;
            clearTimeout(this.timer);
            this.timer = setTimeout(() => { this.loading = false; }, 10000);
            this.$root.postReq("/web/tmquery/tmqueryCtl/findTrademarkNameAccurate", obj).then(d => {
                this.loading = false;
                console.log("精确商标查询+++++++++++++++++++");
                console.log(d);
                if (d && d.status == 0 && d.data) {
                    this.total = d.data.count;
                    this.tmList = d.data.rows;


                    this.code_counts = d.data.code_counts;
                    if (!this.ncl_list || this.ncl_list.length < 1) {
                        this.ncl_list = d.data.code_counts || [];
                    }
                    if (!this.legal_status_list || this.legal_status_list.length < 1) {
                        this.legal_status_list = d.data.status_counts || [];
                    }
                    if (!this.apply_year_list || this.apply_year_list.length < 1) {
                        this.apply_year_list = d.data.year_counts || [];
                    }
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**模糊商标查询 */
        similarTmSearch(){
            /*    var obj = { 
                        "tmName": "输入的商标名字",
                        "sqlbtabkey": "选中的申请类别",
                        "flzttabkey": "选中的商标状态",
                        "sqnftabkey": "选中的商标申请年份",
                        "ncl": ["首页选中的商标大类"],
                        "xcl": ["选中的商标大类下的群组"],
                        "nclNum": ["选中进入搜索页面商标大类"],
                        "sbtjdata":["近似", "变字", "拼音", "同义词", "形近字", "换序", "包含该商标"],
                        "pageSize": 20,
                        "currentPage": 1 
                };*/
            if (!this.text) {
                this.$message.warning("请输入商标名称");
                return;
            }
            var obj = {
                "tmName": this.text, pageSize: this.pagesize, currentPage: this.currentpage,
                sqlbtabkey: [], xcl: [], ncl: [], nclNum: []
            };
            if (this.selected_ncl_list && this.selected_ncl_list.length > 0) {
                var selected_ncl_list = [];
                Object.assign(selected_ncl_list, this.selected_ncl_list);
                var index = selected_ncl_list.indexOf("不限");
                if (index >= 0) {
                    selected_ncl_list.splice(index, 1);
                }
                obj["nclNum"] = selected_ncl_list;
                obj["ncl"] = selected_ncl_list;
                obj["sqlbtabkey"] = selected_ncl_list;
            }
            if (this.selected_apply_year_list && this.selected_apply_year_list.length > 0) {
                var selected_apply_year_list = [];
                Object.assign(selected_apply_year_list, this.selected_apply_year_list);
                var index = selected_apply_year_list.indexOf("不限");
                if (index >= 0) {
                    selected_apply_year_list.splice(index, 1);
                }
                obj["sqnftabkey"] = selected_apply_year_list;
            }
            if (this.selected_legal_status_list && this.selected_legal_status_list.length > 0) {
                var selected_legal_status_list = [];
                Object.assign(selected_legal_status_list, this.selected_legal_status_list);
                var index = selected_legal_status_list.indexOf("不限");
                if (index >= 0) {
                    selected_legal_status_list.splice(index, 1);
                }
                obj["flzttabkey"] = selected_legal_status_list;
            }
            if (this.selected_checkboxLabelHigh && this.selected_checkboxLabelHigh.length > 0) {
                var selected_checkboxLabelHigh = [];
                Object.assign(selected_checkboxLabelHigh, this.selected_checkboxLabelHigh);
                var index = selected_checkboxLabelHigh.indexOf("不限");
                if (index >= 0) {
                    selected_checkboxLabelHigh.splice(index, 1);
                }
                obj["sbtjdata"] = selected_checkboxLabelHigh;
                if (selected_checkboxLabelHigh.length < 1) {
                    obj["sbtjdata"] = ["近似", "变字", "拼音", "同义词", "形近字", "换序", "包含该商标"];
                }
            } else {
                obj["sbtjdata"] = ["近似", "变字", "拼音", "同义词", "形近字", "换序", "包含该商标"];
            }
            this.loading = true;
            clearTimeout(this.timer);
            this.timer = setTimeout(() => { this.loading = false; }, 10000);
            this.$root.postReq("/web/tmquery/tmqueryCtl/findTrademarkName", obj).then(d => {
                this.loading = false;
                console.log("模糊商标查询+++++++++++++++++++");
                console.log(d);
                if (d && d.status == 0 && d.data) {
                    this.total = d.data.count;
                    this.tmList = d.data.rows;

                    if (!this.ncl_list || this.ncl_list.length < 1) {
                        this.ncl_list = d.data.code_counts || [];
                    }
                    if (!this.legal_status_list || this.legal_status_list.length < 1) {
                        this.legal_status_list = d.data.status_counts || [];
                    }
                    if (!this.apply_year_list || this.apply_year_list.length < 1) {
                        this.apply_year_list = d.data.year_counts || [];
                    }
                    this.checkboxLabelHigh = ["近似", "变字", "拼音", "同义词", "形近字", "换序", "包含该商标"];
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**注册号商标查询 */
        regNumTmSearch(){
            /*var obj = { 
                    "regNum": "输入的商标号",
                    "sqlbtabkey": "选中的申请类别",
                    "flzttabkey": "选中的商标状态",
                    "sqnftabkey": "选中的商标申请年份",
                    "xcl": ["选中的商标大类下的群组"],
                    "pageSize": 20,
                    "currentPage": 1 
            };*/
            if (!this.text) {
                this.$message.warning("请输入商标申请号");
                return;
            }
            var obj = {
                "regNum": this.text, pageSize: this.pagesize, currentPage: this.currentpage,
                sqlbtabkey: [], xcl: [],
            };
            if (this.selected_ncl_list && this.selected_ncl_list.length > 0) {
                var selected_ncl_list = [];
                Object.assign(selected_ncl_list, this.selected_ncl_list);
                var index = selected_ncl_list.indexOf("不限");
                if (index >= 0) {
                    selected_ncl_list.splice(index, 1);
                }
                obj["nclNum"] = selected_ncl_list;
                obj["ncl"] = selected_ncl_list;
                obj["sqlbtabkey"] = selected_ncl_list;
            }
            if (this.selected_apply_year_list && this.selected_apply_year_list.length > 0) {
                var selected_apply_year_list = [];
                Object.assign(selected_apply_year_list, this.selected_apply_year_list);
                var index = selected_apply_year_list.indexOf("不限");
                if (index >= 0) {
                    selected_apply_year_list.splice(index, 1);
                }
                obj["sqnftabkey"] = selected_apply_year_list;
            }
            if (this.selected_legal_status_list && this.selected_legal_status_list.length > 0) {
                var selected_legal_status_list = [];
                Object.assign(selected_legal_status_list, this.selected_legal_status_list);
                var index = selected_legal_status_list.indexOf("不限");
                if (index >= 0) {
                    selected_legal_status_list.splice(index, 1);
                }
                obj["flzttabkey"] = selected_legal_status_list;
            }
            this.loading = true;
            clearTimeout(this.timer);
            this.timer = setTimeout(() => { this.loading = false; }, 10000);

            this.$root.postReq("/web/tmquery/tmqueryCtl/findTrademarkzchAccurate", obj).then(d => {
                this.loading = false;
                console.log("注册号商标查询+++++++++++++++++++");
                console.log(d);
                if (d && d.status == 0 && d.data) {
                    this.total = d.data.count;
                    this.tmList = d.data.rows;
                    if (!this.ncl_list || this.ncl_list.length < 1) {
                        this.ncl_list = d.data.code_counts || [];
                    }
                    if (!this.legal_status_list || this.legal_status_list.length < 1) {
                        this.legal_status_list = d.data.status_counts || [];
                    }
                    if (!this.apply_year_list || this.apply_year_list.length < 1) {
                        this.apply_year_list = d.data.year_counts || [];
                    }
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**申请人商标查询 */
        applierTmSearch(){
            /*var obj = { 
                    "regMan": "输入的申请人名字",
                    "sqlbtabkey": "选中的申请类别",
                    "flzttabkey": "选中的商标状态",
                    "sqnftabkey": "选中的商标申请年份",
                    "zcrname": "选中的申请人名称",
                    "xcl": ["选中的商标大类下的群组"],
                    "pageSize": 20,
                    "currentPage": 1 
            };*/
            if (!this.text) {
                this.$message.warning("请输入申请人名字");
                return;
            }
            var obj = {
                "regMan": this.text, pageSize: this.pagesize, currentPage: this.currentpage,
                sqlbtabkey: [], xcl: [],
            };
            if (this.selected_ncl_list && this.selected_ncl_list.length > 0) {
                var selected_ncl_list = [];
                Object.assign(selected_ncl_list, this.selected_ncl_list);
                var index = selected_ncl_list.indexOf("不限");
                if (index >= 0) {
                    selected_ncl_list.splice(index, 1);
                }
                obj["nclNum"] = selected_ncl_list;
                obj["ncl"] = selected_ncl_list;
                obj["sqlbtabkey"] = selected_ncl_list;
            }
            if (this.selected_apply_year_list && this.selected_apply_year_list.length > 0) {
                var selected_apply_year_list = [];
                Object.assign(selected_apply_year_list, this.selected_apply_year_list);
                var index = selected_apply_year_list.indexOf("不限");
                if (index >= 0) {
                    selected_apply_year_list.splice(index, 1);
                }
                obj["sqnftabkey"] = selected_apply_year_list;
            }
            if (this.selected_legal_status_list && this.selected_legal_status_list.length > 0) {
                var selected_legal_status_list = [];
                Object.assign(selected_legal_status_list, this.selected_legal_status_list);
                var index = selected_legal_status_list.indexOf("不限");
                if (index >= 0) {
                    selected_legal_status_list.splice(index, 1);
                }
                obj["flzttabkey"] = selected_legal_status_list;
            }
            this.loading = true;
            clearTimeout(this.timer);
            this.timer = setTimeout(() => { this.loading = false; }, 10000);
            this.$root.postReq("/web/tmquery/tmqueryCtl/findTrademarkzcr", obj).then(d => {
                this.loading = false;
                console.log("申请人商标查询+++++++++++++++++++");
                console.log(d);
                if (d && d.status == 0 && d.data) {
                    this.total = d.data.count;
                    this.tmList = d.data.rows;
                    if (!this.ncl_list || this.ncl_list.length < 1) {
                        this.ncl_list = d.data.code_counts || [];
                    }
                    if (!this.legal_status_list || this.legal_status_list.length < 1) {
                        this.legal_status_list = d.data.status_counts || [];
                    }
                    if (!this.apply_year_list || this.apply_year_list.length < 1) {
                        this.apply_year_list = d.data.year_counts || [];
                    }
                }
            }).catch(function (e) {
                that.loading = false;
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /**图像商标检索 */
        imageTmsearch(){
            var obj = {
                imageUrl: this.imageUrl
            };
            this.$root.postReq("/web/tmquery/tmqueryCtl/imagequery", obj).then(d => {
                console.log("图像商标检索+++++++++++++++++++");
                console.log(d);
                if (d && d.status == 0 && d.data) {
                    this.tmRegistNumsAll = d.data.rows;
                    if (!this.ncl_list || this.ncl_list.length < 1) {
                        this.ncl_list = d.data.code_counts || [];
                    }
                    if (!this.legal_status_list || this.legal_status_list.length < 1) {
                        this.legal_status_list = d.data.status_counts || [];
                    }
                    if (!this.apply_year_list || this.apply_year_list.length < 1) {
                        this.apply_year_list = d.data.year_counts || [];
                    }
                    this.pageChanged();
                }
            }).catch(function (e) {

                that.$message.warning(`操作失败，请刷新页面后重新操作`);
            });
        },
        /*精确注册分布 */
        findTrademarkName(tabsName){
            var obj = {
                "tmName": this.text,
            };
            var url = "";
            if (tabsName == 0) {
                var url = '/web/tmquery/tmqueryCtl/findTrademarkNameAccuratejuhe';
            } else if (tabsName == 1) {
                var url = '/web/tmquery/tmqueryCtl/findTrademarkNamejuhe';
            }
            this.$root.postReq(url, obj).then((d) => {
                if (d.status == 0 && d.data) {
                    this.province_counts_o = d.data.province_counts.slice(0, 5).map((item, index) => {
                        item.index = index + 1;
                        return item;
                    });
                    this.province_counts_t = d.data.province_counts.slice(5, 10).map((item, index) => {
                        item.index = index + 6;
                        return item;
                    });
                    if(d.data.province_counts.length){
                        var num1 = this.province_counts_o.length;
                        for(var i = 0; i < 5 - num1; i++){
                            this.province_counts_o.push({
                                count: "-",
                                index: "-",
                                percent: "-",
                                province: "-"
                            })
                        }
                        var num2 = this.province_counts_t.length;
                        for(var j = 0; j < 5 - num2; j++){
                            this.province_counts_t.push({
                                count: "-",
                                index: "-",
                                percent: "-",
                                province: "-"
                            })
                        }
                    }
                    this.ncl_counts_o = d.data.ncl_counts.slice(0, 5).map((item, index) => {
                        item.index = index + 1;
                        return item;
                    });
                    this.ncl_counts_t = d.data.ncl_counts.slice(5, 10).map((item, index) => {
                        item.index = index + 6;
                        return item;
                    });
                    if(d.data.ncl_counts.length){
                        var num1 = this.ncl_counts_o.length;
                        for(var i = 0; i < 5 - num1; i++){
                            this.ncl_counts_o.push({
                                code: "-",
                                count: "-",
                                index: "-",
                                percent: "-"
                            })
                        }
                        var num2 = this.ncl_counts_t.length;
                        for(var j = 0; j < 5 - num2; j++){
                            this.ncl_counts_t.push({
                                code: "-",
                                count: "-",
                                index: "-",
                                percent: "-"
                            })
                        }
                    }
                }
            });
        },
        pageChanged(){
            var obj = {
                tmRegistNumsAll: this.tmRegistNumsAll,
                xcl: [],
                pageInfo: {
                    pageSize: this.pagesize,
                    pageNo: this.currentpage
                }
            };
            /*
            sqlbtabkey: this.sqlbtabkey,
                flzttabkey: this.flzttabkey,
                sqnftabkey: this.sqnftabkey,
                xcl: this.checkedXcl,
            if(this.selected_ncl_list && this.selected_ncl_list.length>0){
                obj["nclNum"] = this.selected_ncl_list;
                obj["ncl"] = this.selected_ncl_list;
            }*/
            if (this.selected_ncl_list && this.selected_ncl_list.length > 0) {
                var selected_ncl_list = [];
                Object.assign(selected_ncl_list, this.selected_ncl_list);
                var index = selected_ncl_list.indexOf("不限");
                if (index >= 0) {
                    selected_ncl_list.splice(index, 1);
                }
                obj["sqlbtabkey"] = selected_ncl_list;
            }
            if (this.selected_apply_year_list && this.selected_apply_year_list.length > 0) {
                var selected_apply_year_list = [];
                Object.assign(selected_apply_year_list, this.selected_apply_year_list);
                var index = selected_apply_year_list.indexOf("不限");
                if (index >= 0) {
                    selected_apply_year_list.splice(index, 1);
                }
                obj["sqnftabkey"] = selected_apply_year_list;
            }
            if (this.selected_legal_status_list && this.selected_legal_status_list.length > 0) {
                var selected_legal_status_list = [];
                Object.assign(selected_legal_status_list, this.selected_legal_status_list);
                var index = selected_legal_status_list.indexOf("不限");
                if (index >= 0) {
                    selected_legal_status_list.splice(index, 1);
                }
                obj["flzttabkey"] = selected_legal_status_list;
            }
            var that = this;
            console.log(obj);
            this.loading = true;
            this.$root.postReq("/web/tmquery/tmqueryCtl/findImageSearch", obj).then(function (d) {
                console.log("findImageSearch");
                console.log(d);
                if (d.status == 0) {
                    that.total = d.data.count;
                    that.tmList = d.data.rows;
                    that.loading = false;
                }
            }).catch(function (e) {
                console.log(e);
                that.$message.warning(`操作失败，请刷新页面后重新操作`);
                that.loading = false;
            });
        },
        tabClick(){
            this.currentpage="1";
            console.log(this.tabsName=="4");
            if (this.tabsName == "4") {
                if(this.imageText){
                    this.imageTmsearch();
                }
                console.log("qweqwweq");
                console.log(1234);
            }
            if (this.text && this.tabsName != "4") {
                this.tmSearchButtonClick();
            } else {
                this.tmList = [];
                this.ncl_list = [];
                this.selected_ncl_list = ["不限"];
                this.legal_status_list = [];
                this.selected_legal_status_list = ["不限"];
                this.apply_year_list = [];
                this.selected_apply_year_list = ["不限"];
                this.checkboxLabelHigh = [];
                this.selected_checkboxLabelHigh = ["不限"];
                this.total = 0;
                this.province_counts_o= [];
                this.province_counts_t= [];
                this.ncl_counts_o= [];
                this.ncl_counts_t= [];
            }
        },
        nclchange(v){
            console.log(v);
            if (v.length > 0) {
                var len = v.length;
                var opt = v[len - 1];
                if (opt == "不限") {
                    this.selected_ncl_list = ["不限"];
                } else {
                    var index = this.selected_ncl_list.indexOf("不限");
                    if (index >= 0) {
                        this.selected_ncl_list.splice(index, 1);
                    }
                }
            } else {
                this.selected_ncl_list = ["不限"];
            }
            this.tmSearch();
        },
        legalstatuschange(v){
            console.log(v);
            if (v.length > 0) {
                var len = v.length;
                var opt = v[len - 1];
                if (opt == "不限") {
                    this.selected_legal_status_list = ["不限"];
                } else {
                    var index = this.selected_legal_status_list.indexOf("不限");
                    if (index >= 0) {
                        this.selected_legal_status_list.splice(index, 1);
                    }

                }
            } else {
                this.selected_legal_status_list = ["不限"];
            }
            this.tmSearch();
        },
        yearchange(v){
            if (v.length > 0) {
                var len = v.length;
                var opt = v[len - 1];
                if (opt == "不限") {
                    this.selected_apply_year_list = ["不限"];
                } else {
                    var index = this.selected_apply_year_list.indexOf("不限");
                    if (index >= 0) {
                        this.selected_apply_year_list.splice(index, 1);
                    }

                }
            } else {
                this.selected_apply_year_list = ["不限"];
            }
            this.tmSearch();
        },
        advancedsearchchange(v){
            if (v.length > 0) {
                var len = v.length;
                var opt = v[len - 1];
                if (opt == "不限") {
                    this.selected_checkboxLabelHigh = ["不限"];
                } else {
                    var index = this.selected_checkboxLabelHigh.indexOf("不限");
                    if (index >= 0) {
                        this.selected_checkboxLabelHigh.splice(index, 1);
                    }

                }
            } else {
                this.selected_checkboxLabelHigh = ["不限"];
            }
            this.tmSearch();
        },
        /** */
        uploadImg: function(e, num) {
            console.log("++++++++133333+++++++++++++");
            var file = e.target.files[0];
            if (!/\.(gif|jpg|jpeg|png|bmp|GIF|JPG|PNG)$/.test(e.target.value)) {
                alert('图片类型必须是.gif,jpeg,jpg,png,bmp中的一种');
                return false;
            }
            $('#wave-container').css('display', 'none');
            console.log("file");
            console.log(file);
            console.log(e);
            /*
            this.text = file.name;
            */
            this.imageText = file.name;
            console.log(this.imageText, "......................");
            var reader = new FileReader();
            var that = this;
            reader.onload = (e) => {
                var data = null;
                if (typeof e.target.result === 'object') {
                    data = window.URL.createObjectURL(new Blob([e.target.result]));
                } else {
                    data = e.target.result;
                }
                if (num == 1) {
                    this.option.img = data;
                } else if (num == 2) {
                    this.example2.img = data;
                }

                var image = new Image();
                image.src = data;
                image.onload = function () {
                    that.option.autoCropWidth = image.width;
                    that.option.autoCropHeight = image.height;
                    console.log("+++++++++++++++++++++++++");
                    console.log(that.option.autoCropWidth, that.option.autoCropHeight);
                };
            };
            reader.readAsArrayBuffer(file);
            this.showcropper = true;
            var _input = $('#uploads');
            _input.val('');
        },
        imgLoad: function(msg) {
            console.log("imgLoad");
            console.log(msg);
        },
        submit: function() {
            var aLink = document.createElement('a');
            var that = this;
            aLink.download = 'demo';

            this.$refs.cropper.getCropData((data) => {
                this.$root.postReq("/web/tmquery/toolCtl/getCropperPic", { base64: data }).then(d => {
                    console.log("dddddddddddddgetCropperPic");
                    console.log(d);
                    that.showcropper = false;
                    if (d) {
                        that.imageUrl = d;
                        that.tag.name = that.picName;
                        that.tabsName = "4";
                        this.tmList = [];
                        this.ncl_list = [];
                        this.selected_ncl_list = ["不限"];
                        this.legal_status_list = [];
                        this.selected_legal_status_list = ["不限"];
                        this.apply_year_list = [];
                        this.selected_apply_year_list = ["不限"];
                        this.checkboxLabelHigh = [];
                        this.selected_checkboxLabelHigh = ["不限"];
                        that.imageTmsearch();
                    }
                }).catch(function (e) {

                    console.log(e);
                });
            });

        },
        realTime: function(data) {
            this.previews = data;
            console.log(data);
        },
        hideCropper: function() {
            var _input = $('#uploads');
            _input.val('');
            this.showcropper = false;
            this.option.img = "";
        },
        /** */
        toTmDetail(row){
            console.log(row);
            if (row && row.gjfl && row.sbzch) {
                this.$router.push({ path: '/brandfinddetails', query: { regNum: row.sbzch, nclNum: row.gjfl } });
                /*
                let routeData = this.$router.resolve({
                    path: "/brandfinddetails",
                    query: { regNum: row.sbzch, nclNum: row.gjfl },
                });
                window.open(routeData.href, '_blank');
                */
            }
        },
        imageTextDelete(){
            this.imageText = "";
            this.imageUrl = "";
            this.tmList = [];
            this.ncl_list = [];
            this.selected_ncl_list = ["不限"];
            this.legal_status_list = [];
            this.selected_legal_status_list = ["不限"];
            this.apply_year_list = [];
            this.selected_apply_year_list = ["不限"];
            this.checkboxLabelHigh = [];
            this.selected_checkboxLabelHigh = ["不限"];
            this.imageTmsearch();
        },
        currentChange(v){
            console.log(v);
            this.currentpage = v;
            this.tmSearch();
        },
        aa(){
            alert(1);
        }
    },
    vname: "gsb_brandfind"
}
